/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.netty;

import org.apache.james.pop3server.POP3HandlerConfigurationData;
import org.apache.james.pop3server.core.CoreCmdHandlerLoader;
import org.apache.james.pop3server.jmx.JMXHandlersLoader;
import org.apache.james.pop3server.netty.POP3ChannelUpstreamHandler;
import org.apache.james.pop3server.netty.POP3ResponseEncoder;
import org.apache.james.pop3server.netty.POP3ServerMBean;
import org.apache.james.protocols.api.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class POP3Server
extends AbstractProtocolAsyncServer
implements POP3ServerMBean {
    private POP3HandlerConfigurationData theConfigData = new POP3HandlerConfigurationDataImpl();

    protected int getDefaultPort() {
        return 110;
    }

    public String getServiceType() {
        return "POP3 Service";
    }

    protected String getDefaultJMXName() {
        return "pop3server";
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new POP3ChannelUpstreamHandler(this.getProtocolHandlerChain(), this.theConfigData, this.getLogger(), this.getSSLContext(), this.getEnabledCipherSuites());
    }

    protected OneToOneEncoder createEncoder() {
        return new POP3ResponseEncoder();
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    private class POP3HandlerConfigurationDataImpl
    implements POP3HandlerConfigurationData {
        private POP3HandlerConfigurationDataImpl() {
        }

        @Override
        public String getHelloName() {
            return POP3Server.this.getHelloName();
        }

        @Override
        public int getResetLength() {
            return -1;
        }

        @Override
        public boolean isStartTLSSupported() {
            return POP3Server.this.isStartTLSSupported();
        }
    }
}

