/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.EnableRequest;
import org.apache.james.imap.message.response.EnableResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.mailbox.MailboxManager;

public class EnableProcessor
extends AbstractMailboxProcessor<EnableRequest>
implements CapabilityImplementingProcessor {
    private final List<PermitEnableCapabilityProcessor> capabilities = new ArrayList<PermitEnableCapabilityProcessor>();
    private static final String ENABLED_CAPABILITIES = "ENABLED_CAPABILITIES";

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<PermitEnableCapabilityProcessor> capabilities) {
        this(next, mailboxManager, factory);
        this.capabilities.addAll(capabilities);
    }

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(EnableRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(EnableRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        List caps = request.getCapabilities();
        HashSet<String> enabledCaps = new HashSet<String>();
        for (int i = 0; i < caps.size(); ++i) {
            String cap = (String)caps.get(i);
            for (int a = 0; a < this.capabilities.size(); ++a) {
                if (!this.capabilities.get(a).getPermitEnableCapabilities(session).contains(cap)) continue;
                enabledCaps.add(cap);
            }
        }
        EnableProcessor.getEnabledCapabilities(session).addAll(enabledCaps);
        responder.respond((ImapResponseMessage)new EnableResponse(new ArrayList(enabledCaps)));
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(command, tag, responder);
    }

    public void addProcessor(PermitEnableCapabilityProcessor implementor) {
        this.capabilities.add(implementor);
    }

    public static Set<String> getEnabledCapabilities(ImapSession session) {
        HashSet caps = (HashSet)session.getAttribute(ENABLED_CAPABILITIES);
        if (caps == null) {
            caps = new HashSet();
            session.setAttribute(ENABLED_CAPABILITIES, caps);
        }
        return caps;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        ArrayList<String> capabilities = new ArrayList<String>();
        capabilities.add("ENABLE");
        return capabilities;
    }
}

