/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.ExpungeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageRangeException;

public class ExpungeProcessor
extends AbstractMailboxProcessor<ExpungeRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> UIDPLUS = Arrays.asList("UIDPLUS");

    public ExpungeProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(ExpungeRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(ExpungeRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            if (!mailbox.isWriteable(mailboxSession)) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_IS_READ_ONLY);
            } else {
                IdRange[] ranges = request.getUidSet();
                if (ranges == null) {
                    this.expunge(mailbox, MessageRange.all(), session, mailboxSession);
                } else {
                    for (int i = 0; i < ranges.length; ++i) {
                        MessageRange mRange = this.messageRange(session.getSelected(), ranges[i], true);
                        if (mRange == null) continue;
                        this.expunge(mailbox, mRange, session, mailboxSession);
                    }
                }
                this.unsolicitedResponses(session, responder, false);
                this.okComplete(command, tag, responder);
            }
        }
        catch (MessageRangeException e) {
            session.getLog().debug("Expunge failed", (Throwable)e);
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            session.getLog().debug("Expunge failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void expunge(MessageManager mailbox, MessageRange range, ImapSession session, MailboxSession mailboxSession) throws MailboxException {
        Iterator it = mailbox.expunge(range, mailboxSession);
        SelectedMailbox selected = session.getSelected();
        if (mailboxSession != null) {
            while (it.hasNext()) {
                long uid = (Long)it.next();
                selected.removeRecent(uid);
            }
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return UIDPLUS;
    }
}

