/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxMetaData;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxQuery;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.util.SimpleMailboxMetaData;

public class ListProcessor
extends AbstractMailboxProcessor<ListRequest> {
    public ListProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(ListRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(ListRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String baseReferenceName = request.getBaseReferenceName();
        String mailboxPatternString = request.getMailboxPattern();
        this.doProcess(baseReferenceName, mailboxPatternString, session, tag, command, responder, null);
    }

    protected ImapResponseMessage createResponse(boolean noInferior, boolean noSelect, boolean marked, boolean unmarked, boolean hasChildren, boolean hasNoChildren, String mailboxName, char delimiter, MailboxType type) {
        return new ListResponse(noInferior, noSelect, marked, unmarked, hasChildren, hasNoChildren, mailboxName, delimiter);
    }

    protected final void doProcess(String referenceName, String mailboxName, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, MailboxTyper mailboxTyper) {
        try {
            List<Object> results;
            boolean isRelative;
            String user = ImapSessionUtils.getUserName((ImapSession)session);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            if (mailboxName.length() == 0) {
                String referenceRoot;
                if (referenceName.length() > 0 && referenceName.charAt(0) == '#') {
                    isRelative = false;
                    int firstDelimiter = referenceName.indexOf(mailboxSession.getPathDelimiter());
                    referenceRoot = firstDelimiter == -1 ? referenceName : referenceName.substring(0, firstDelimiter);
                } else {
                    referenceRoot = "";
                    isRelative = true;
                }
                MailboxPath rootPath = new MailboxPath(referenceRoot, "", "");
                results = new ArrayList<MailboxMetaData>(1);
                results.add(SimpleMailboxMetaData.createNoSelect((MailboxPath)rootPath, (char)mailboxSession.getPathDelimiter()));
            } else {
                String finalReferencename = referenceName;
                if (mailboxName.charAt(0) == '#') {
                    finalReferencename = "";
                }
                isRelative = (finalReferencename + mailboxName).charAt(0) != '#';
                MailboxPath basePath = null;
                basePath = isRelative ? new MailboxPath("#private", user, finalReferencename) : this.buildFullPath(session, finalReferencename);
                results = this.getMailboxManager().search(new MailboxQuery(basePath, mailboxName, mailboxSession.getPathDelimiter()), mailboxSession);
            }
            for (MailboxMetaData metaData : results) {
                this.processResult(responder, isRelative, metaData, this.getMailboxType(session, mailboxTyper, metaData.getPath()));
            }
            this.okComplete(command, tag, responder);
        }
        catch (MailboxException e) {
            session.getLog().debug("List failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    void processResult(ImapProcessor.Responder responder, boolean relative, MailboxMetaData listResult, MailboxType mailboxType) {
        char delimiter = listResult.getHierarchyDelimiter();
        String mailboxName = this.mailboxName(relative, listResult.getPath(), delimiter);
        MailboxMetaData.Children inferiors = listResult.inferiors();
        boolean noInferior = MailboxMetaData.Children.NO_INFERIORS.equals((Object)inferiors);
        boolean hasChildren = MailboxMetaData.Children.HAS_CHILDREN.equals((Object)inferiors);
        boolean hasNoChildren = MailboxMetaData.Children.HAS_NO_CHILDREN.equals((Object)inferiors);
        boolean noSelect = false;
        boolean marked = false;
        boolean unmarked = false;
        switch (listResult.getSelectability()) {
            case MARKED: {
                marked = true;
                break;
            }
            case UNMARKED: {
                unmarked = true;
                break;
            }
            case NOSELECT: {
                noSelect = true;
                break;
            }
        }
        responder.respond(this.createResponse(noInferior, noSelect, marked, unmarked, hasChildren, hasNoChildren, mailboxName, delimiter, mailboxType));
    }

    private MailboxType getMailboxType(ImapSession session, MailboxTyper mailboxTyper, MailboxPath path) {
        MailboxType result = MailboxType.OTHER;
        if (mailboxTyper != null) {
            result = mailboxTyper.getMailboxType(session, path);
        }
        return result;
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return ListRequest.class.equals(message.getClass());
    }
}

