/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.ImapStateAwareMailboxListener;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.UpdatedFlags;

public class MailboxEventAnalyser
extends ImapStateAwareMailboxListener {
    private final long sessionId;
    private Set<Long> flagUpdateUids;
    private Flags.Flag uninterestingFlag;
    private Set<Long> expungedUids;
    private boolean isDeletedByOtherSession = false;
    private boolean sizeChanged = false;
    private boolean silentFlagChanges = false;
    private MailboxPath mailboxPath;
    private boolean closed = false;
    private Flags applicableFlags;
    private boolean applicableFlagsChanged;

    public MailboxEventAnalyser(ImapSession session, MailboxPath mailboxPath, Flags applicableFlags) {
        super(session);
        this.sessionId = ImapSessionUtils.getMailboxSession((ImapSession)session).getSessionId();
        this.flagUpdateUids = new TreeSet<Long>();
        this.expungedUids = new TreeSet<Long>();
        this.uninterestingFlag = Flags.Flag.RECENT;
        this.mailboxPath = mailboxPath;
        this.applicableFlags = applicableFlags;
    }

    public synchronized MailboxPath getMailboxPath() {
        return this.mailboxPath;
    }

    public synchronized void setMailboxPath(MailboxPath mailboxPath) {
        this.mailboxPath = mailboxPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(MailboxListener.Event event) {
        if (event.getMailboxPath().equals((Object)this.getMailboxPath())) {
            long eventSessionId = event.getSession().getSessionId();
            if (event instanceof MailboxListener.MessageEvent) {
                MailboxListener.MessageEvent messageEvent = (MailboxListener.MessageEvent)event;
                if (messageEvent instanceof MailboxListener.Added) {
                    this.sizeChanged = true;
                } else if (messageEvent instanceof MailboxListener.FlagsUpdated) {
                    Object flags;
                    SelectedMailbox sm;
                    MailboxListener.FlagsUpdated updated = (MailboxListener.FlagsUpdated)messageEvent;
                    List uFlags = updated.getUpdatedFlags();
                    if (this.sessionId != eventSessionId || !this.silentFlagChanges) {
                        for (int i = 0; i < uFlags.size(); ++i) {
                            UpdatedFlags u = (UpdatedFlags)uFlags.get(i);
                            if (!this.interestingFlags(u)) continue;
                            Set<Long> set = this.flagUpdateUids;
                            synchronized (set) {
                                this.flagUpdateUids.add(u.getUid());
                                continue;
                            }
                        }
                    }
                    if ((sm = this.session.getSelected()) != null) {
                        List uflags = updated.getUpdatedFlags();
                        for (int i = 0; i < uflags.size(); ++i) {
                            UpdatedFlags u = (UpdatedFlags)uflags.get(i);
                            flags = u.systemFlagIterator();
                            while (flags.hasNext()) {
                                MailboxPath path;
                                if (!Flags.Flag.RECENT.equals(flags.next()) || (path = sm.getPath()) == null || !path.equals((Object)event.getMailboxPath())) continue;
                                sm.addRecent(u.getUid());
                            }
                        }
                    }
                    Flags flags2 = this.applicableFlags;
                    synchronized (flags2) {
                        int size = this.applicableFlags.getUserFlags().length;
                        MailboxListener.FlagsUpdated updatedF = (MailboxListener.FlagsUpdated)messageEvent;
                        flags = updatedF.getUpdatedFlags();
                        for (int i = 0; i < flags.size(); ++i) {
                            this.applicableFlags.add(((UpdatedFlags)flags.get(i)).getNewFlags());
                        }
                        this.applicableFlags.remove(Flags.Flag.RECENT);
                        if (size < this.applicableFlags.getUserFlags().length) {
                            this.applicableFlagsChanged = true;
                        }
                    }
                } else if (messageEvent instanceof MailboxListener.Expunged) {
                    Set<Long> set = this.expungedUids;
                    synchronized (set) {
                        this.expungedUids.addAll(messageEvent.getUids());
                    }
                }
            } else if (event instanceof MailboxListener.MailboxDeletion) {
                if (eventSessionId != this.sessionId) {
                    this.isDeletedByOtherSession = true;
                }
            } else if (event instanceof MailboxListener.MailboxRenamed) {
                MailboxListener.MailboxRenamed mailboxRenamed = (MailboxListener.MailboxRenamed)event;
                this.setMailboxPath(mailboxRenamed.getNewPath());
            }
        }
    }

    private boolean interestingFlags(UpdatedFlags updated) {
        Flags.Flag flag;
        Iterator it = updated.systemFlagIterator();
        boolean result = it.hasNext() ? !(flag = (Flags.Flag)it.next()).equals(this.uninterestingFlag) : false;
        if (!result) {
            Iterator userIt = updated.userFlagIterator();
            result = userIt.hasNext();
        }
        return result;
    }

    public synchronized void reset() {
        this.sizeChanged = false;
        this.flagUpdateUids.clear();
        this.isDeletedByOtherSession = false;
        this.applicableFlagsChanged = false;
    }

    public synchronized void resetExpungedUids() {
        this.expungedUids.clear();
    }

    public final boolean isSilentFlagChanges() {
        return this.silentFlagChanges;
    }

    public final void setSilentFlagChanges(boolean silentFlagChanges) {
        this.silentFlagChanges = silentFlagChanges;
    }

    public final boolean isSizeChanged() {
        return this.sizeChanged;
    }

    public final boolean isDeletedByOtherSession() {
        return this.isDeletedByOtherSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> flagUpdateUids() {
        Set<Long> set = this.flagUpdateUids;
        synchronized (set) {
            return Collections.unmodifiableSet(new TreeSet<Long>(this.flagUpdateUids));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> expungedUids() {
        Set<Long> set = this.expungedUids;
        synchronized (set) {
            return Collections.unmodifiableSet(new TreeSet<Long>(this.expungedUids));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExpungedUids() {
        Set<Long> set = this.expungedUids;
        synchronized (set) {
            return !this.expungedUids.isEmpty();
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.flagUpdateUids.clear();
        this.flagUpdateUids = null;
        this.uninterestingFlag = null;
        this.expungedUids.clear();
        this.expungedUids = null;
    }

    @Override
    protected synchronized boolean isListenerClosed() {
        return this.closed;
    }

    public synchronized Flags getApplicableFlags() {
        return this.applicableFlags;
    }

    public synchronized boolean hasNewApplicableFlags() {
        return this.applicableFlagsChanged;
    }

    public synchronized void resetNewApplicableFlags() {
        this.applicableFlagsChanged = false;
    }
}

