/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.MailboxEventAnalyser;
import org.apache.james.imap.processor.base.UidToMsnConverter;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;

public class SelectedMailboxImpl
implements SelectedMailbox {
    private final MailboxEventAnalyser events;
    private final UidToMsnConverter converter;
    private final Set<Long> recentUids = new TreeSet<Long>();
    private boolean recentUidRemoved = false;

    public SelectedMailboxImpl(MailboxManager mailboxManager, Iterator<Long> uids, Flags applicableFlags, ImapSession session, MailboxPath path) throws MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        this.events = new MailboxEventAnalyser(session, path, applicableFlags);
        this.events.setSilentFlagChanges(true);
        mailboxManager.addListener(path, (MailboxListener)this.events, mailboxSession);
        this.converter = new UidToMsnConverter(session, uids);
        mailboxManager.addListener(path, (MailboxListener)this.converter, mailboxSession);
    }

    public void deselect() {
        this.converter.close();
        this.events.close();
        this.recentUids.clear();
    }

    public boolean isSizeChanged() {
        return this.events.isSizeChanged();
    }

    public int msn(long uid) {
        return this.converter.getMsn(uid);
    }

    public boolean isDeletedByOtherSession() {
        return this.events.isDeletedByOtherSession();
    }

    public long uid(int msn) {
        return this.converter.getUid(msn);
    }

    public boolean removeRecent(long uid) {
        boolean result = this.recentUids.remove(uid);
        if (result) {
            this.recentUidRemoved = true;
        }
        return result;
    }

    public boolean addRecent(long uid) {
        return this.recentUids.add(uid);
    }

    public Collection<Long> getRecent() {
        this.checkExpungedRecents();
        return new ArrayList<Long>(this.recentUids);
    }

    public int recentCount() {
        this.checkExpungedRecents();
        return this.recentUids.size();
    }

    public long existsCount() {
        return this.converter.getCount();
    }

    public MailboxPath getPath() {
        return this.events.getMailboxPath();
    }

    private void checkExpungedRecents() {
        for (long uid : this.events.expungedUids()) {
            this.removeRecent(uid);
        }
    }

    public boolean isRecent(long uid) {
        return this.recentUids.contains(uid);
    }

    public boolean isRecentUidRemoved() {
        return this.recentUidRemoved;
    }

    public void resetRecentUidRemoved() {
        this.recentUidRemoved = false;
    }

    public void resetEvents() {
        this.events.reset();
    }

    public Collection<Long> expungedUids() {
        return this.events.expungedUids();
    }

    public int remove(Long uid) {
        int result = this.msn(uid);
        this.converter.expunge(uid);
        return result;
    }

    public Collection<Long> flagUpdateUids() {
        return this.events.flagUpdateUids();
    }

    public long getFirstUid() {
        return this.converter.getFirstUid();
    }

    public long getLastUid() {
        return this.converter.getLastUid();
    }

    public void resetExpungedUids() {
        this.events.resetExpungedUids();
    }

    public Flags getApplicableFlags() {
        return this.events.getApplicableFlags();
    }

    public boolean hasNewApplicableFlags() {
        return this.events.hasNewApplicableFlags();
    }

    public void resetNewApplicableFlags() {
        this.events.resetNewApplicableFlags();
    }
}

