/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;

public class MessageResultUtils {
    public static List<MessageResult.Header> getAll(Iterator<MessageResult.Header> iterator) {
        ArrayList<MessageResult.Header> results = new ArrayList<MessageResult.Header>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                results.add(iterator.next());
            }
        }
        return results;
    }

    public static List<MessageResult.Header> getMatching(String[] names, Iterator<MessageResult.Header> iterator) throws MailboxException {
        ArrayList<MessageResult.Header> results = new ArrayList<MessageResult.Header>(20);
        if (iterator != null) {
            block0: while (iterator.hasNext()) {
                MessageResult.Header header = iterator.next();
                String headerName = header.getName();
                if (headerName == null) continue;
                for (String name : names) {
                    if (!headerName.equalsIgnoreCase(name)) continue;
                    results.add(header);
                    continue block0;
                }
            }
        }
        return results;
    }

    public static List<MessageResult.Header> getMatching(Collection<String> names, Iterator<MessageResult.Header> iterator) throws MailboxException {
        List<MessageResult.Header> result = MessageResultUtils.matching(names, iterator, false);
        return result;
    }

    private static List<MessageResult.Header> matching(Collection<String> names, Iterator<MessageResult.Header> iterator, boolean not) throws MailboxException {
        ArrayList<MessageResult.Header> results = new ArrayList<MessageResult.Header>(names.size());
        if (iterator != null) {
            while (iterator.hasNext()) {
                MessageResult.Header header = iterator.next();
                boolean match = MessageResultUtils.contains(names, header);
                boolean add = not && !match || !not && match;
                if (!add) continue;
                results.add(header);
            }
        }
        return results;
    }

    private static boolean contains(Collection<String> names, MessageResult.Header header) throws MailboxException {
        boolean match = false;
        String headerName = header.getName();
        if (headerName != null) {
            for (String name : names) {
                if (!name.equalsIgnoreCase(headerName)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public static List<MessageResult.Header> getNotMatching(Collection<String> names, Iterator<MessageResult.Header> iterator) throws MailboxException {
        List<MessageResult.Header> result = MessageResultUtils.matching(names, iterator, true);
        return result;
    }

    public static MessageResult.Header getMatching(String name, Iterator<MessageResult.Header> iterator) throws MailboxException {
        MessageResult.Header result = null;
        if (name != null) {
            while (iterator.hasNext()) {
                MessageResult.Header header = iterator.next();
                String headerName = header.getName();
                if (!name.equalsIgnoreCase(headerName)) continue;
                result = header;
                break;
            }
        }
        return result;
    }

    public static List<MessageResult.Header> getNotMatching(String[] names, Iterator<MessageResult.Header> iterator) throws MailboxException {
        ArrayList<MessageResult.Header> results = new ArrayList<MessageResult.Header>(20);
        if (iterator != null) {
            while (iterator.hasNext()) {
                MessageResult.Header header = iterator.next();
                String headerName = header.getName();
                if (headerName == null) continue;
                int length = names.length;
                boolean match = false;
                for (int i = 0; i < length; ++i) {
                    String name = names[i];
                    if (!headerName.equalsIgnoreCase(name)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                results.add(header);
            }
        }
        return results;
    }
}

