/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class MethodStoreQuery
extends AbstractStoreQuery {
    public static final String LANGUAGE = "openjpa.MethodQL";
    private static final Class[] ARGS_DATASTORE = new Class[]{StoreContext.class, ClassMetaData.class, Boolean.TYPE, Map.class, FetchConfiguration.class};
    private static final Class[] ARGS_INMEM = new Class[]{StoreContext.class, ClassMetaData.class, Boolean.TYPE, Object.class, Map.class, FetchConfiguration.class};
    private static final int OBJ_INDEX = 3;
    private static final Localizer _loc = Localizer.forPackage(MethodStoreQuery.class);
    private OrderedMap<Object, Class<?>> _params = null;

    @Override
    public void invalidateCompilation() {
        if (this._params != null) {
            this._params.clear();
        }
    }

    @Override
    public StoreQuery.Executor newInMemoryExecutor(ClassMetaData meta, boolean subs) {
        return new MethodExecutor(this, meta, subs, true);
    }

    @Override
    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subs) {
        return new MethodExecutor(this, meta, subs, false);
    }

    @Override
    public boolean supportsInMemoryExecution() {
        return true;
    }

    @Override
    public boolean supportsDataStoreExecution() {
        return true;
    }

    @Override
    public boolean requiresCandidateType() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedMap<Object, Class<?>> bindParameterTypes() {
        this.ctx.lock();
        try {
            if (this._params != null) {
                OrderedMap<Object, Class<?>> orderedMap = this._params;
                return orderedMap;
            }
            String params = this.ctx.getParameterDeclaration();
            if (params == null) {
                OrderedMap orderedMap = EMPTY_ORDERED_PARAMS;
                return orderedMap;
            }
            List<String> decs = Filters.parseDeclaration(params, ',', "parameters");
            if (this._params == null) {
                this._params = new OrderedMap();
            }
            for (int i = 0; i < decs.size(); i += 2) {
                String name = decs.get(i);
                Class<?> cls = this.ctx.classForName(name, null);
                if (cls == null) {
                    throw new UserException(_loc.get("bad-param-type", name));
                }
                this._params.put(decs.get(i + 1), cls);
            }
            OrderedMap<Object, Class<?>> orderedMap = this._params;
            return orderedMap;
        }
        finally {
            this.ctx.unlock();
        }
    }

    private static class MethodExecutor
    extends AbstractStoreQuery.AbstractExecutor
    implements StoreQuery.Executor {
        private final ClassMetaData _meta;
        private final boolean _subs;
        private final boolean _inMem;
        private Method _meth = null;

        public MethodExecutor(MethodStoreQuery q, ClassMetaData candidate, boolean subclasses, boolean inMem) {
            this._meta = candidate;
            this._subs = subclasses;
            this._inMem = inMem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            ResultObjectProvider rop;
            HashMap paramMap;
            if (params.length == 0) {
                paramMap = Collections.EMPTY_MAP;
            } else {
                OrderedMap<Object, Class<?>> paramTypes = q.getContext().getOrderedParameterTypes();
                paramMap = new HashMap((int)((double)params.length * 1.33 + 1.0));
                int idx = 0;
                Iterator itr = paramTypes.keySet().iterator();
                while (itr.hasNext()) {
                    paramMap.put(itr.next(), params[idx]);
                    ++idx;
                }
            }
            FetchConfiguration fetch = q.getContext().getFetchConfiguration();
            StoreContext sctx = q.getContext().getStoreContext();
            if (this._inMem) {
                Object[] args = new Object[]{sctx, this._meta, this._subs ? Boolean.TRUE : Boolean.FALSE, null, paramMap, fetch};
                Iterator itr = null;
                Collection<?> coll = q.getContext().getCandidateCollection();
                if (coll == null) {
                    Extent ext = q.getContext().getQuery().getCandidateExtent();
                    itr = ext.iterator();
                } else {
                    itr = coll.iterator();
                }
                ArrayList results = new ArrayList();
                try {
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (obj == null || !this._meta.getDescribedType().isInstance(obj)) continue;
                        args[3] = obj;
                        if (!((Boolean)this.invoke(q, args)).booleanValue()) continue;
                        results.add(obj);
                    }
                }
                finally {
                    ImplHelper.close(itr);
                }
                rop = new ListResultObjectProvider(results);
            } else {
                Object[] args = new Object[]{sctx, this._meta, this._subs ? Boolean.TRUE : Boolean.FALSE, paramMap, fetch};
                rop = (ResultObjectProvider)this.invoke(q, args);
            }
            if (range.start != 0L || range.end != Long.MAX_VALUE) {
                rop = new RangeResultObjectProvider(rop, range.start, range.end);
            }
            return rop;
        }

        private Object invoke(StoreQuery q, Object[] args) {
            this.validate(q);
            try {
                return this._meth.invoke(null, args);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new UserException(_loc.get("method-error", this._meth, Exceptions.toString(Arrays.asList(args))), (Throwable)e);
            }
        }

        @Override
        public void validate(StoreQuery q) {
            Method meth;
            Class<?> cls;
            if (this._meth != null) {
                return;
            }
            String methName = q.getContext().getQueryString();
            if (StringUtils.isEmpty((String)methName)) {
                throw new UserException(_loc.get("no-method"));
            }
            int dotIdx = methName.lastIndexOf(46);
            if (dotIdx == -1) {
                cls = this._meta.getDescribedType();
            } else {
                cls = q.getContext().classForName(methName.substring(0, dotIdx), null);
                if (cls == null) {
                    throw new UserException(_loc.get("bad-method-class", methName.substring(0, dotIdx), methName));
                }
                methName = methName.substring(dotIdx + 1);
            }
            Class[] types = this._inMem ? ARGS_INMEM : ARGS_DATASTORE;
            try {
                meth = cls.getMethod(methName, types);
            }
            catch (Exception e) {
                String msg = this._inMem ? "bad-inmem-method" : "bad-datastore-method";
                throw new UserException(_loc.get(msg, methName, cls));
            }
            if (!Modifier.isStatic(meth.getModifiers())) {
                throw new UserException(_loc.get("method-not-static", meth));
            }
            if (!ResultObjectProvider.class.isAssignableFrom(meth.getReturnType())) {
                throw new UserException(_loc.get("method-return-type-invalid", meth, meth.getReturnType()));
            }
            this._meth = meth;
        }

        @Override
        public OrderedMap<Object, Class<?>> getOrderedParameterTypes(StoreQuery q) {
            return ((MethodStoreQuery)q).bindParameterTypes();
        }

        public Object[] toParameterArray(StoreQuery q, Map userParams) {
            if (userParams == null || userParams.isEmpty()) {
                return StoreQuery.EMPTY_OBJECTS;
            }
            OrderedMap<Object, Class<?>> paramTypes = this.getOrderedParameterTypes(q);
            Object[] arr = new Object[userParams.size()];
            int base = MethodExecutor.positionalParameterBase(userParams.keySet());
            for (Object key : paramTypes.keySet()) {
                int idx;
                int n = idx = key instanceof Integer ? (Integer)key - base : paramTypes.indexOf(key);
                if (idx >= arr.length || idx < 0) {
                    throw new UserException(_loc.get("gap-query-param", new Object[]{q.getContext().getQueryString(), key, userParams.size(), userParams}));
                }
                arr[idx] = userParams.get(key);
            }
            return arr;
        }

        private static int positionalParameterBase(Collection params) {
            int low = Integer.MAX_VALUE;
            for (Object obj : params) {
                if (!(obj instanceof Number)) {
                    return 0;
                }
                int val = ((Number)obj).intValue();
                if (val == 0) {
                    return val;
                }
                if (val >= low) continue;
                low = val;
            }
            return low;
        }
    }
}

