/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.EnumSet;

public enum AutoDetachType {
    CLOSE(2),
    COMMIT(4),
    NON_TRANSACTIONAL_READ(8),
    ROLLBACK(16);

    private final int autoDetachConstant;

    private AutoDetachType(int value) {
        this.autoDetachConstant = value;
    }

    public static EnumSet<AutoDetachType> toEnumSet(int autoDetach) {
        EnumSet<AutoDetachType> types = EnumSet.noneOf(AutoDetachType.class);
        if ((autoDetach & 2) != 0) {
            types.add(CLOSE);
        }
        if ((autoDetach & 4) != 0) {
            types.add(COMMIT);
        }
        if ((autoDetach & 8) != 0) {
            types.add(NON_TRANSACTIONAL_READ);
        }
        if ((autoDetach & 0x10) != 0) {
            types.add(ROLLBACK);
        }
        return types;
    }

    public static int fromEnumSet(EnumSet<AutoDetachType> types) {
        int autoDetach = 0;
        for (AutoDetachType type : types) {
            autoDetach |= type.autoDetachConstant;
        }
        return autoDetach;
    }
}

