/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.MacroData;
import org.apache.james.jspf.core.SPF1Utils;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroExpand {
    private Pattern domainSpecPattern = Pattern.compile("((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*)((?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)))");
    private Pattern macroStringPattern = Pattern.compile("\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1}");
    private Pattern macroLettersPattern;
    private Pattern macroLettersExpPattern = Pattern.compile("[rctlsodipvhRCTLSODIPVH]");
    private Pattern cellPattern;
    private Logger log;
    private DNSService dnsProbe;
    public static final boolean EXPLANATION = true;
    public static final boolean DOMAIN = false;
    private static final String ATTRIBUTE_MACRO_EXPAND_CHECKED_RECORD = "MacroExpand.checkedRecord";

    public MacroExpand(Logger logger, DNSService dnsProbe) {
        this.macroLettersPattern = Pattern.compile("[lsodipvhLSODIPVH]");
        this.log = logger;
        this.dnsProbe = dnsProbe;
    }

    public DNSLookupContinuation checkExpand(String input, SPFSession session, boolean isExplanation) throws PermErrorException, NoneException {
        String host;
        if (input != null && (host = this.expand(input, session, isExplanation)) == null) {
            return new DNSLookupContinuation(new DNSRequest(IPAddr.getAddress(session.getIpAddress()).getReverseIP(), 4), new PTRResponseListener());
        }
        return null;
    }

    public String expand(String input, MacroData macroData, boolean isExplanation) throws PermErrorException {
        try {
            if (isExplanation) {
                return this.expandExplanation(input, macroData);
            }
            return this.expandDomain(input, macroData);
        }
        catch (RequireClientDomainException e) {
            return null;
        }
    }

    private String expandExplanation(String input, MacroData macroData) throws PermErrorException, RequireClientDomainException {
        this.log.debug("Start do expand explanation: " + input);
        String[] parts = input.split(" ");
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                res.append(" ");
            }
            res.append(this.expandMacroString(parts[i], macroData, true));
        }
        this.log.debug("Done expand explanation: " + res);
        return res.toString();
    }

    private String expandDomain(String input, MacroData macroData) throws PermErrorException, RequireClientDomainException {
        this.log.debug("Start expand domain: " + input);
        Matcher inputMatcher = this.domainSpecPattern.matcher(input);
        if (!inputMatcher.matches() || inputMatcher.groupCount() != 2) {
            throw new PermErrorException("Invalid DomainSpec: " + input);
        }
        StringBuffer res = new StringBuffer();
        if (inputMatcher.group(1) != null && inputMatcher.group(1).length() > 0) {
            res.append(this.expandMacroString(inputMatcher.group(1), macroData, false));
        }
        if (inputMatcher.group(2) != null && inputMatcher.group(2).length() > 0) {
            if (inputMatcher.group(2).startsWith(".")) {
                res.append(inputMatcher.group(2));
            } else {
                res.append(this.expandMacroString(inputMatcher.group(2), macroData, false));
            }
        }
        String domainName = this.expandMacroString(input, macroData, false);
        int split = 0;
        while (domainName.length() > 255 && split > -1) {
            split = domainName.indexOf(".");
            domainName = domainName.substring(split + 1);
        }
        this.log.debug("Domain expanded: " + domainName);
        return domainName;
    }

    private String expandMacroString(String input, MacroData macroData, boolean isExplanation) throws PermErrorException, RequireClientDomainException {
        StringBuffer decodedValue = new StringBuffer();
        Matcher inputMatcher = this.macroStringPattern.matcher(input);
        int pos = 0;
        while (inputMatcher.find()) {
            String match2 = inputMatcher.group();
            if (pos != inputMatcher.start()) {
                throw new PermErrorException("Middle part does not match: " + input.substring(0, pos) + ">>" + input.substring(pos, inputMatcher.start()) + "<<" + input.substring(inputMatcher.start()) + " [" + input + "]");
            }
            if (match2.length() > 0) {
                if (match2.startsWith("%{")) {
                    String macroCell = input.substring(inputMatcher.start() + 2, inputMatcher.end() - 1);
                    inputMatcher.appendReplacement(decodedValue, this.escapeForMatcher(this.replaceCell(macroCell, macroData, isExplanation)));
                } else if (match2.length() == 2 && match2.startsWith("%")) {
                    if ("%_".equals(match2)) {
                        inputMatcher.appendReplacement(decodedValue, " ");
                    } else if ("%-".equals(match2)) {
                        inputMatcher.appendReplacement(decodedValue, "%20");
                    } else {
                        inputMatcher.appendReplacement(decodedValue, this.escapeForMatcher(match2.substring(1)));
                    }
                }
            }
            pos = inputMatcher.end();
        }
        if (input.length() != pos) {
            throw new PermErrorException("End part does not match: " + input.substring(pos));
        }
        inputMatcher.appendTail(decodedValue);
        return decodedValue.toString();
    }

    private String replaceCell(String replaceValue, MacroData macroData, boolean isExplanation) throws PermErrorException, RequireClientDomainException {
        String variable = "";
        String domainNumber = "";
        boolean isReversed = false;
        String delimeters = ".";
        String commandCharacter = replaceValue.substring(0, 1);
        Matcher cellMatcher = isExplanation ? this.macroLettersExpPattern.matcher(commandCharacter) : this.macroLettersPattern.matcher(commandCharacter);
        if (!cellMatcher.find()) {
            throw new PermErrorException("MacroLetter not found: " + replaceValue);
        }
        variable = cellMatcher.group().toUpperCase().equals(cellMatcher.group()) ? this.encodeURL(this.matchMacro(cellMatcher.group(), macroData)) : this.matchMacro(cellMatcher.group(), macroData);
        replaceValue = replaceValue.substring(1);
        this.cellPattern = Pattern.compile("\\d+");
        cellMatcher = this.cellPattern.matcher(replaceValue);
        while (cellMatcher.find()) {
            domainNumber = cellMatcher.group();
            if (Integer.parseInt(domainNumber) != 0) continue;
            throw new PermErrorException("Digit transformer must be non-zero");
        }
        this.cellPattern = Pattern.compile("r");
        cellMatcher = this.cellPattern.matcher(replaceValue);
        while (cellMatcher.find()) {
            isReversed = true;
        }
        this.cellPattern = Pattern.compile("[\\.\\-\\+\\,\\/\\_\\=]+");
        cellMatcher = this.cellPattern.matcher(replaceValue);
        while (cellMatcher.find()) {
            delimeters = cellMatcher.group();
        }
        ArrayList<String> data = this.split(variable, delimeters);
        if (isReversed) {
            data = this.reverse(data);
        }
        String returnData = !domainNumber.equals("") ? this.subset(data, Integer.parseInt(domainNumber)) : this.subset(data);
        return returnData;
    }

    private String matchMacro(String macro, MacroData macroData) throws PermErrorException, RequireClientDomainException {
        String rValue = null;
        String variable = macro.toLowerCase();
        if (variable.equalsIgnoreCase("i")) {
            rValue = macroData.getMacroIpAddress();
        } else if (variable.equalsIgnoreCase("s")) {
            rValue = macroData.getMailFrom();
        } else if (variable.equalsIgnoreCase("h")) {
            rValue = macroData.getHostName();
        } else if (variable.equalsIgnoreCase("l")) {
            rValue = macroData.getCurrentSenderPart();
        } else if (variable.equalsIgnoreCase("d")) {
            rValue = macroData.getCurrentDomain();
        } else if (variable.equalsIgnoreCase("v")) {
            rValue = macroData.getInAddress();
        } else if (variable.equalsIgnoreCase("t")) {
            rValue = Long.toString(macroData.getTimeStamp());
        } else if (variable.equalsIgnoreCase("c")) {
            rValue = macroData.getReadableIP();
        } else if (variable.equalsIgnoreCase("p")) {
            rValue = macroData.getClientDomain();
            if (rValue == null) {
                throw new RequireClientDomainException();
            }
        } else if (variable.equalsIgnoreCase("o")) {
            rValue = macroData.getSenderDomain();
        } else if (variable.equalsIgnoreCase("r") && (rValue = macroData.getReceivingDomain()) == null) {
            rValue = "unknown";
            List<String> dNames = this.dnsProbe.getLocalDomainNames();
            for (int i = 0; i < dNames.size(); ++i) {
                if (!SPF1Utils.checkFQDN(dNames.get(i).toString())) continue;
                rValue = dNames.get(i).toString();
                if (!(macroData instanceof SPFSession)) break;
                ((SPFSession)macroData).setReceivingDomain(rValue);
                break;
            }
        }
        if (rValue == null) {
            throw new PermErrorException("Unknown command : " + variable);
        }
        this.log.debug("Used macro: " + macro + " replaced with: " + rValue);
        return rValue;
    }

    private ArrayList<String> split(String data, String delimeters) {
        StringBuffer element = new StringBuffer();
        ArrayList<String> splitParts = new ArrayList<String>();
        for (int i = 0; i < data.length(); ++i) {
            String currentChar = data.substring(i, i + 1);
            if (delimeters.indexOf(currentChar) > -1) {
                splitParts.add(element.toString());
                element.setLength(0);
                continue;
            }
            element.append(currentChar);
        }
        splitParts.add(element.toString());
        return splitParts;
    }

    private ArrayList<String> reverse(ArrayList<String> data) {
        ArrayList<String> reversed = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            reversed.add(0, data.get(i));
        }
        return reversed;
    }

    private String subset(ArrayList<String> data) {
        return this.subset(data, data.size());
    }

    private String subset(ArrayList<String> data, int length) {
        int start;
        StringBuffer buildString = new StringBuffer();
        if (data.size() < length) {
            length = data.size();
        }
        for (int i = start = data.size() - length; i < data.size(); ++i) {
            if (buildString.length() > 0) {
                buildString.append(".");
            }
            buildString.append(data.get(i));
        }
        return buildString.toString();
    }

    private String encodeURL(String data) {
        try {
            data = URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return data.replaceAll("\\+", "%20");
    }

    private String escapeForMatcher(String raw) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c == '$' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final class PTRResponseListener
    implements SPFCheckerDNSResponseListener {
        private PTRResponseListener() {
        }

        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            try {
                boolean ip6 = IPAddr.isIPV6(session.getIpAddress());
                List<String> records = response.getResponse();
                if (records != null && records.size() > 0) {
                    String record = records.get(0);
                    session.setAttribute(MacroExpand.ATTRIBUTE_MACRO_EXPAND_CHECKED_RECORD, record);
                    return new DNSLookupContinuation(new DNSRequest(record, ip6 ? 2 : 1), new AResponseListener());
                }
            }
            catch (TimeoutException e) {
                session.setClientDomain("unknown");
            }
            return null;
        }
    }

    private static final class AResponseListener
    implements SPFCheckerDNSResponseListener {
        private AResponseListener() {
        }

        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            block4: {
                session.setClientDomain("unknown");
                try {
                    List<String> records = response.getResponse();
                    if (records == null || records.size() <= 0) break block4;
                    for (String next : records) {
                        if (!IPAddr.getAddress(session.getIpAddress()).toString().equals(IPAddr.getAddress(next).toString())) continue;
                        session.setClientDomain((String)session.getAttribute(MacroExpand.ATTRIBUTE_MACRO_EXPAND_CHECKED_RECORD));
                        break;
                    }
                }
                catch (TimeoutException e) {
                }
                catch (PermErrorException permErrorException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class RequireClientDomainException
    extends Exception {
        private static final long serialVersionUID = 3834282981657676530L;
    }
}

