/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.policies.SPFRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPFStrictCheckerRetriever
extends SPFRetriever {
    private static final String ATTRIBUTE_SPFSTRICT_CHECK_SPFRECORDS = "SPFStrictCheck.SPFRecords";

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        SPF1Record res = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
        if (res == null) {
            String currentDomain = spfData.getCurrentDomain();
            return new DNSLookupContinuation(new DNSRequest(currentDomain, 6), new SPFStrictCheckDNSResponseListener());
        }
        return null;
    }

    private static String calculateSpfRecord(List<String> spfR, List<String> spfTxtR) throws PermErrorException {
        String spfR1 = null;
        String spfR2 = null;
        if (spfR != null) {
            spfR1 = SPFStrictCheckerRetriever.extractSPFRecord(spfR);
        }
        if (spfTxtR != null) {
            spfR2 = SPFStrictCheckerRetriever.extractSPFRecord(spfTxtR);
        }
        if (spfR1 != null && spfR2 == null) {
            return spfR1;
        }
        if (spfR1 == null && spfR2 != null) {
            return spfR2;
        }
        if (spfR1 != null && spfR2 != null) {
            if (!spfR1.toLowerCase().equals(spfR2.toLowerCase())) {
                throw new PermErrorException("Published SPF records not equals");
            }
            return spfR1;
        }
        return null;
    }

    private static final class SPFStrictCheckDNSResponseListener
    implements SPFCheckerDNSResponseListener {
        private SPFStrictCheckDNSResponseListener() {
        }

        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            try {
                List<String> spfR = response.getResponse();
                session.setAttribute(SPFStrictCheckerRetriever.ATTRIBUTE_SPFSTRICT_CHECK_SPFRECORDS, spfR);
                String currentDomain = session.getCurrentDomain();
                return new DNSLookupContinuation(new DNSRequest(currentDomain, 5), new SPFStrictSPFRecordsDNSResponseListener());
            }
            catch (TimeoutException e) {
                throw new TempErrorException("Timeout querying dns");
            }
        }
    }

    private static final class SPFStrictSPFRecordsDNSResponseListener
    implements SPFCheckerDNSResponseListener {
        private SPFStrictSPFRecordsDNSResponseListener() {
        }

        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            List spfR = (List)session.getAttribute(SPFStrictCheckerRetriever.ATTRIBUTE_SPFSTRICT_CHECK_SPFRECORDS);
            List<String> spfTxtR = null;
            try {
                spfTxtR = response.getResponse();
            }
            catch (TimeoutException e) {
                throw new TempErrorException("Timeout querying dns");
            }
            String record = SPFStrictCheckerRetriever.calculateSpfRecord(spfR, spfTxtR);
            if (record != null) {
                session.setAttribute("SPF.SPF1Record", new SPF1Record(record));
            }
            return null;
        }
    }
}

