/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies.local;

import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.policies.PolicyPostFilter;
import org.apache.james.jspf.terms.Directive;
import org.apache.james.jspf.terms.IncludeMechanism;

public class TrustedForwarderPolicy
implements PolicyPostFilter {
    public static final String TRUSTED_FORWARDER_HOST = "spf.trusted-forwarder.org";
    private Logger log;

    public TrustedForwarderPolicy(Logger log) {
        this.log = log;
    }

    public SPF1Record getSPFRecord(String currentDomain, SPF1Record spfRecord) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (spfRecord == null) {
            return null;
        }
        String mechanism = spfRecord.getDirectives().get(spfRecord.getDirectives().size()).toString();
        if (mechanism.equals("-all") || mechanism.equals("?all")) {
            this.log.debug("Add TrustedForwarderPolicy = include:spf.trusted-forwarder.org");
            try {
                IncludeMechanism trusted = new IncludeMechanism(){

                    public synchronized IncludeMechanism setHost(String host) {
                        this.host = host;
                        return this;
                    }
                }.setHost(TRUSTED_FORWARDER_HOST);
                spfRecord.getDirectives().add(spfRecord.getDirectives().size() - 1, new Directive(null, trusted, this.log.getChildLogger("trustedforwarder")));
            }
            catch (PermErrorException e) {
                // empty catch block
            }
        }
        return spfRecord;
    }
}

