/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.DNSServiceEnabled;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.terms.GenericMechanism;

public class PTRMechanism
extends GenericMechanism
implements DNSServiceEnabled,
SPFCheckerDNSResponseListener {
    private static final String ATTRIBUTE_CURRENT_DOMAIN = "PTRMechanism.currentDomain";
    private static final String ATTRIBUTE_EXPANDED_HOST = "PTRMechanism.expandedHost";
    private static final String ATTRIBUTE_DOMAIN_LIST = "PTRMechanism.domainListCheck";
    public static final String REGEX = "[pP][tT][rR](?:\\:((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-))))?";
    private DNSService dnsService;
    private SPFChecker expandedChecker = new ExpandedChecker();

    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        spfData.increaseCurrentDepth();
        spfData.pushChecker(this.expandedChecker);
        return this.macroExpand.checkExpand(this.getDomain(), spfData, false);
    }

    public void enableDNSService(DNSService service) {
        this.dnsService = service;
    }

    public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession spfSession) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        List<String> domainList = (List<String>)spfSession.getAttribute(ATTRIBUTE_DOMAIN_LIST);
        try {
            if (domainList == null) {
                domainList = response.getResponse();
                if (domainList == null) {
                    spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
                    return null;
                }
                if (this.dnsService.getRecordLimit() > 0 && domainList.size() > this.dnsService.getRecordLimit()) {
                    domainList = domainList.subList(0, this.dnsService.getRecordLimit() - 1);
                }
                spfSession.setAttribute(ATTRIBUTE_DOMAIN_LIST, domainList);
            } else {
                String compareDomain = (String)spfSession.getAttribute(ATTRIBUTE_CURRENT_DOMAIN);
                String host = (String)spfSession.getAttribute(ATTRIBUTE_EXPANDED_HOST);
                List<String> aList = response.getResponse();
                if (aList != null) {
                    for (int j = 0; j < aList.size(); ++j) {
                        if (!IPAddr.getAddress(aList.get(j)).getIPAddress().equals(IPAddr.getAddress(spfSession.getIpAddress()).getIPAddress()) || !compareDomain.equals(host) && !compareDomain.endsWith("." + host)) continue;
                        spfSession.setAttribute("Mechanism.result", Boolean.TRUE);
                        return null;
                    }
                }
            }
        }
        catch (TimeoutException e) {
            throw new TempErrorException("Timeout querying the dns server");
        }
        if (domainList.size() > 0) {
            String currentDomain = domainList.remove(0);
            DNSRequest dnsRequest = IPAddr.isIPV6(spfSession.getIpAddress()) ? new DNSRequest(currentDomain, 2) : new DNSRequest(currentDomain, 1);
            spfSession.setAttribute(ATTRIBUTE_CURRENT_DOMAIN, currentDomain);
            return new DNSLookupContinuation(dnsRequest, this);
        }
        spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
        return null;
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private CleanupChecker cleanupChecker = new CleanupChecker();

        private ExpandedChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            IPAddr ip = IPAddr.getAddress(spfData.getIpAddress());
            String host = PTRMechanism.this.expandHost(spfData);
            spfData.setAttribute(PTRMechanism.ATTRIBUTE_EXPANDED_HOST, host);
            spfData.pushChecker(this.cleanupChecker);
            return new DNSLookupContinuation(new DNSRequest(ip.getReverseIP(), 4), PTRMechanism.this);
        }

        private final class CleanupChecker
        implements SPFChecker {
            private CleanupChecker() {
            }

            public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
                spfData.removeAttribute(PTRMechanism.ATTRIBUTE_DOMAIN_LIST);
                spfData.removeAttribute(PTRMechanism.ATTRIBUTE_CURRENT_DOMAIN);
                return null;
            }
        }
    }
}

