/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class POP3BeforeSMTPHelper {
    public static Map<String, Long> ipMap = Collections.synchronizedMap(new HashMap());
    public static final long EXPIRE_TIME = 216000000L;

    private POP3BeforeSMTPHelper() {
    }

    public static boolean isAuthorized(String ipAddress) {
        return ipMap.containsKey(ipAddress);
    }

    public static void addIPAddress(String ipAddress) {
        ipMap.put(ipAddress, System.currentTimeMillis());
    }

    public static void removeExpiredIP() {
        POP3BeforeSMTPHelper.removeExpiredIP(216000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExpiredIP(long clearTime) {
        Map<String, Long> map = ipMap;
        synchronized (map) {
            Iterator<String> storedIP = ipMap.keySet().iterator();
            long currTime = System.currentTimeMillis();
            while (storedIP.hasNext()) {
                String key = storedIP.next().toString();
                long storedTime = ipMap.get(key);
                if (currTime - clearTime <= storedTime) continue;
                storedIP.remove();
                ipMap.remove(key);
            }
        }
    }

    public static void clearIP() {
        ipMap.clear();
    }
}

