/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.CommandHandlerResultHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.lib.jmx.AbstractCommandHandlerStats;

public abstract class AbstractCommandHandlerResultJMXMonitor<R extends Response, S extends ProtocolSession>
implements CommandHandlerResultHandler<R, S>,
ExtensibleHandler,
LifecycleAwareProtocolHandler {
    private Map<String, AbstractCommandHandlerStats<R>> cStats = new HashMap<String, AbstractCommandHandlerStats<R>>();
    private String jmxName;

    public Response onResponse(ProtocolSession session, R response, long executionTime, CommandHandler<S> handler) {
        String name = handler.getClass().getName();
        AbstractCommandHandlerStats<R> stats = this.cStats.get(name);
        if (stats != null) {
            stats.increment(response);
        }
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(CommandHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(CommandHandler.class)) {
            for (int i = 0; i < extension.size(); ++i) {
                CommandHandler c = (CommandHandler)extension.get(i);
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.cStats.put(cName, this.createCommandHandlerStats(c));
                    continue;
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected abstract AbstractCommandHandlerStats<R> createCommandHandlerStats(CommandHandler<S> var1) throws Exception;

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    protected abstract String getDefaultJMXName();

    protected String getJMXName() {
        return this.jmxName;
    }

    public void destroy() {
        Iterator<AbstractCommandHandlerStats<R>> it = this.cStats.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }
}

