/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ConnectHandler;
import org.apache.james.protocols.api.ConnectHandlerResultHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.lib.jmx.ConnectHandlerStats;

public abstract class AbstractConnectHandlerResultJMXMonitor<S extends ProtocolSession>
implements ConnectHandlerResultHandler<S>,
ExtensibleHandler,
LifecycleAwareProtocolHandler {
    private Map<String, ConnectHandlerStats> cStats = new HashMap<String, ConnectHandlerStats>();
    private String jmxName;

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    public void destroy() {
        Iterator<ConnectHandlerStats> it = this.cStats.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }

    public boolean onResponse(ProtocolSession session, boolean response, long executionTime, ConnectHandler<S> handler) {
        this.cStats.get(handler.getClass().getName()).increment(response);
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(ConnectHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(ConnectHandler.class)) {
            for (int i = 0; i < extension.size(); ++i) {
                ConnectHandler c = (ConnectHandler)extension.get(i);
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.cStats.put(cName, new ConnectHandlerStats(this.jmxName, cName));
                    continue;
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected abstract String getDefaultJMXName();
}

