/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.LineHandlerResultHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.lib.jmx.LineHandlerStats;

public abstract class AbstractLineHandlerResultJMXMonitor<S extends ProtocolSession>
implements LineHandlerResultHandler<S>,
ExtensibleHandler,
LifecycleAwareProtocolHandler {
    private Map<String, LineHandlerStats> lStats = new HashMap<String, LineHandlerStats>();
    private String jmxName;

    public boolean onResponse(ProtocolSession session, boolean response, long executionTime, LineHandler<S> handler) {
        this.lStats.get(handler.getClass().getName()).increment(response);
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(LineHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(LineHandler.class)) {
            for (int i = 0; i < extension.size(); ++i) {
                LineHandler c = (LineHandler)extension.get(i);
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.lStats.put(cName, new LineHandlerStats(this.jmxName, cName));
                    continue;
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    public void destroy() {
        Iterator<LineHandlerStats> it = this.lStats.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }

    protected abstract String getDefaultJMXName();
}

