/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.protocols.lib.jmx.HandlerStatsMBean;

public class ConnectHandlerStats
extends StandardMBean
implements HandlerStatsMBean,
Disposable {
    private String name;
    private String handlerName;
    private MBeanServer mbeanserver;
    private AtomicLong disconnect = new AtomicLong(0L);
    private AtomicLong all = new AtomicLong(0L);

    public ConnectHandlerStats(String jmxName, String handlerName) throws NotCompliantMBeanException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException {
        super(HandlerStatsMBean.class);
        this.handlerName = handlerName;
        this.name = "org.apache.james:type=server,name=" + jmxName + ",chain=handlerchain,handler=connecthandler,connecthandler=" + handlerName;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        ObjectName baseObjectName = new ObjectName(this.name);
        this.mbeanserver.registerMBean(this, baseObjectName);
    }

    public void increment(boolean disconnected) {
        if (disconnected) {
            this.disconnect.incrementAndGet();
        }
        this.all.incrementAndGet();
    }

    @Override
    public long getAll() {
        return this.all.get();
    }

    @Override
    public String getName() {
        return this.handlerName;
    }

    @Override
    public long getDisconnect() {
        return this.disconnect.get();
    }

    public void dispose() {
        try {
            this.mbeanserver.unregisterMBean(new ObjectName(this.name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

