/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.protocols.impl.AbstractAsyncServer;
import org.apache.james.protocols.lib.jmx.ServerMBean;
import org.apache.james.protocols.lib.netty.AbstractExecutorAwareChannelPipelineFactory;
import org.apache.james.protocols.lib.netty.ConnectionCountHandler;
import org.apache.james.util.concurrent.JMXEnabledThreadPoolExecutor;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.slf4j.Logger;

public abstract class AbstractConfigurableAsyncServer
extends AbstractAsyncServer
implements LogEnabled,
Configurable,
ServerMBean {
    private static final int DEFAULT_BACKLOG = 200;
    private static final int DEFAULT_TIMEOUT = 300;
    private static final String TIMEOUT_NAME = "connectiontimeout";
    private static final String BACKLOG_NAME = "connectionBacklog";
    public static final String HELLO_NAME = "helloName";
    private static final String defaultX509algorithm = "SunX509";
    private String x509Algorithm = "SunX509";
    private FileSystem fileSystem;
    private Logger logger;
    private boolean enabled;
    protected int connPerIP;
    private boolean useStartTLS;
    private boolean useSSL;
    protected int connectionLimit;
    private String helloName;
    private String keystore;
    private String secret;
    private SSLContext context;
    protected String jmxName;
    private String[] enabledCipherSuites;
    private ConnectionCountHandler countHandler = new ConnectionCountHandler();
    private ExecutionHandler executionHandler = null;
    private int maxExecutorThreads;

    @Resource(name="filesystem")
    public final void setFileSystem(FileSystem filesystem) {
        this.fileSystem = filesystem;
    }

    public final void setLog(Logger logger) {
        this.logger = logger;
    }

    public final void configure(HierarchicalConfiguration config) throws ConfigurationException {
        String connectionLimitPerIP;
        this.enabled = config.getBoolean("[@enabled]", true);
        Logger logger = this.getLogger();
        if (!this.enabled) {
            logger.info(this.getServiceType() + " disabled by configuration");
            return;
        }
        String[] listen = config.getString("bind", "0.0.0.0:" + this.getDefaultPort()).split(",");
        ArrayList<InetSocketAddress> bindAddresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < listen.length; ++i) {
            String[] bind = listen[i].split(":");
            String ip = bind[0].trim();
            int port = Integer.parseInt(bind[1].trim());
            if (!ip.equals("0.0.0.0")) {
                try {
                    ip = InetAddress.getByName(ip).getHostName();
                }
                catch (UnknownHostException unhe) {
                    throw new ConfigurationException("Malformed bind parameter in configuration of service " + this.getServiceType(), (Throwable)unhe);
                }
            }
            InetSocketAddress address = new InetSocketAddress(ip, port);
            StringBuilder infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" bound to: ").append(ip).append(":").append(port);
            logger.info(infoBuffer.toString());
            bindAddresses.add(address);
        }
        this.setListenAddresses(bindAddresses);
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
        int ioWorker = config.getInt("ioWorkerCount", DEFAULT_IO_WORKER_COUNT);
        this.setIoWorkerCount(ioWorker);
        this.maxExecutorThreads = config.getInt("maxExecutorCount", 50);
        this.configureHelloName((Configuration)config);
        this.setTimeout(config.getInt(TIMEOUT_NAME, 300));
        StringBuilder infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" handler connection timeout is: ").append(this.getTimeout());
        logger.info(infoBuffer.toString());
        this.setBacklog(config.getInt(BACKLOG_NAME, 200));
        infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" connection backlog is: ").append(this.getBacklog());
        logger.info(infoBuffer.toString());
        String connectionLimitString = config.getString("connectionLimit", null);
        if (connectionLimitString != null) {
            try {
                this.connectionLimit = new Integer(connectionLimitString);
            }
            catch (NumberFormatException nfe) {
                logger.error("Connection limit value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connectionLimit < 0) {
                logger.error("Connection limit value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connectionLimit > 0) {
                infoBuffer = new StringBuilder(128).append(this.getServiceType()).append(" will allow a maximum of ").append(connectionLimitString).append(" connections.");
                logger.info(infoBuffer.toString());
            }
        }
        if ((connectionLimitPerIP = config.getString("connectionLimitPerIP", null)) != null) {
            try {
                this.connPerIP = new Integer(connectionLimitPerIP);
            }
            catch (NumberFormatException nfe) {
                logger.error("Connection limit per IP value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connPerIP < 0) {
                logger.error("Connection limit per IP value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connPerIP > 0) {
                infoBuffer = new StringBuilder(128).append(this.getServiceType()).append(" will allow a maximum of ").append(this.connPerIP).append(" per IP connections for " + this.getServiceType());
                logger.info(infoBuffer.toString());
            }
        }
        this.useStartTLS = config.getBoolean("tls.[@startTLS]", false);
        this.useSSL = config.getBoolean("tls.[@socketTLS]", false);
        if (this.useSSL && this.useStartTLS) {
            throw new ConfigurationException("startTLS is only supported when using plain sockets");
        }
        if (this.useStartTLS || this.useSSL) {
            this.enabledCipherSuites = config.getStringArray("tls.supportedCipherSuites.cipherSuite");
            this.keystore = config.getString("tls.keystore", null);
            if (this.keystore == null) {
                throw new ConfigurationException("keystore needs to get configured");
            }
            this.secret = config.getString("tls.secret", "");
            this.x509Algorithm = config.getString("tls.algorithm", defaultX509algorithm);
        }
        this.doConfigure(config);
    }

    @PostConstruct
    public final void init() throws Exception {
        if (this.isEnabled()) {
            this.preInit();
            this.buildSSLContext();
            this.executionHandler = this.createExecutionHander();
            this.bind();
            this.getLogger().info("Init " + this.getServiceType() + " done");
        }
    }

    @PreDestroy
    public final void destroy() {
        this.getLogger().info("Dispose " + this.getServiceType());
        if (this.isEnabled()) {
            this.unbind();
            this.postDestroy();
            if (this.executionHandler != null) {
                this.executionHandler.releaseExternalResources();
            }
        }
        this.getLogger().info("Dispose " + this.getServiceType() + " done");
    }

    protected void postDestroy() {
    }

    protected void preInit() throws Exception {
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected void configureHelloName(Configuration handlerConfiguration) throws ConfigurationException {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            hostName = "localhost";
        }
        StringBuilder infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" is running on: ").append(hostName);
        this.getLogger().info(infoBuffer.toString());
        boolean autodetect = handlerConfiguration.getBoolean("helloName.[@autodetect]", true);
        if (autodetect) {
            this.helloName = hostName;
        } else {
            this.helloName = handlerConfiguration.getString(HELLO_NAME);
            if (this.helloName == null || this.helloName.trim().length() < 1) {
                throw new ConfigurationException("Please configure the helloName or use autodetect");
            }
        }
        infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" handler hello name is: ").append(this.helloName);
        this.getLogger().info(infoBuffer.toString());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHelloName() {
        return this.helloName;
    }

    protected boolean isStartTLSSupported() {
        return this.useStartTLS;
    }

    protected boolean isSSLSocket() {
        return this.useSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSSLContext() throws Exception {
        if (this.useStartTLS || this.useSSL) {
            FileInputStream fis = null;
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                fis = new FileInputStream(this.fileSystem.getFile(this.keystore));
                ks.load(fis, this.secret.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.x509Algorithm);
                kmf.init(ks, this.secret.toCharArray());
                this.context = SSLContext.getInstance("TLS");
                this.context.init(kmf.getKeyManagers(), null, null);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    protected abstract int getDefaultPort();

    protected SSLContext getSSLContext() {
        return this.context;
    }

    @Override
    public String getSocketType() {
        if (this.isSSLSocket()) {
            return "secure";
        }
        return "plain";
    }

    @Override
    public boolean getStartTLSSupported() {
        return this.isStartTLSSupported();
    }

    @Override
    public int getMaximumConcurrentConnections() {
        return this.connectionLimit;
    }

    protected Executor createBossExecutor() {
        return JMXEnabledThreadPoolExecutor.newCachedThreadPool((String)("org.apache.james:type=server,name=" + this.jmxName + ",sub-type=threadpool"), (String)"boss");
    }

    protected Executor createWorkerExecutor() {
        return JMXEnabledThreadPoolExecutor.newCachedThreadPool((String)("org.apache.james:type=server,name=" + this.jmxName + ",sub-type=threadpool"), (String)"worker");
    }

    protected abstract String getDefaultJMXName();

    protected String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public boolean isStarted() {
        return this.isBound();
    }

    @Override
    public boolean start() {
        try {
            this.bind();
        }
        catch (Exception e) {
            this.logger.error("Unable to start server");
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        this.unbind();
        return true;
    }

    @Override
    public long getHandledConnections() {
        return this.countHandler.getConnectionsTillStartup();
    }

    @Override
    public int getCurrentConnections() {
        return this.countHandler.getCurrentConnectionCount();
    }

    protected ConnectionCountHandler getConnectionCountHandler() {
        return this.countHandler;
    }

    @Override
    public String[] getBoundAddresses() {
        List addresses = this.getListenAddresses();
        String[] addrs = new String[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            InetSocketAddress address = (InetSocketAddress)addresses.get(i);
            addrs[i] = address.getHostName() + ":" + address.getPort();
        }
        return addrs;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        super.configureBootstrap(bootstrap);
        bootstrap.setOption("child.keepAlive", (Object)true);
    }

    protected ExecutionHandler createExecutionHander() {
        return new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(this.maxExecutorThreads, 0L, 0L));
    }

    protected ExecutionHandler getExecutionHandler() {
        return this.executionHandler;
    }

    protected abstract OneToOneEncoder createEncoder();

    protected abstract ChannelUpstreamHandler createCoreHandler();

    protected ChannelPipelineFactory createPipelineFactory(ChannelGroup group) {
        return new AbstractExecutorAwareChannelPipelineFactory(this.getTimeout(), this.connectionLimit, this.connPerIP, group, this.enabledCipherSuites){

            protected SSLContext getSSLContext() {
                return AbstractConfigurableAsyncServer.this.getSSLContext();
            }

            protected boolean isSSLSocket() {
                return AbstractConfigurableAsyncServer.this.isSSLSocket();
            }

            protected OneToOneEncoder createEncoder() {
                return AbstractConfigurableAsyncServer.this.createEncoder();
            }

            protected ChannelUpstreamHandler createHandler() {
                return AbstractConfigurableAsyncServer.this.createCoreHandler();
            }

            @Override
            protected ConnectionCountHandler getConnectionCountHandler() {
                return AbstractConfigurableAsyncServer.this.getConnectionCountHandler();
            }

            @Override
            protected ExecutionHandler getExecutionHandler() {
                return AbstractConfigurableAsyncServer.this.getExecutionHandler();
            }
        };
    }
}

