/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import org.apache.james.protocols.impl.AbstractSSLAwareChannelPipelineFactory;
import org.apache.james.protocols.lib.netty.ConnectionCountHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;

public abstract class AbstractExecutorAwareChannelPipelineFactory
extends AbstractSSLAwareChannelPipelineFactory {
    public AbstractExecutorAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup group) {
        super(timeout, maxConnections, maxConnectsPerIp, group);
    }

    public AbstractExecutorAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup group, String[] enabledCipherSuites) {
        super(timeout, maxConnections, maxConnectsPerIp, group, enabledCipherSuites);
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeLine = super.getPipeline();
        pipeLine.addBefore("coreHandler", "countHandler", (ChannelHandler)this.getConnectionCountHandler());
        ExecutionHandler ehandler = this.getExecutionHandler();
        if (ehandler != null) {
            pipeLine.addBefore("coreHandler", "executionHandler", (ChannelHandler)ehandler);
        }
        return pipeLine;
    }

    protected abstract ExecutionHandler getExecutionHandler();

    protected abstract ConnectionCountHandler getConnectionCountHandler();
}

