/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.protocols.api.HandlersPackage;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.ProtocolHandlerChainImpl;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;

public abstract class AbstractProtocolAsyncServer
extends AbstractConfigurableAsyncServer {
    private ProtocolHandlerChainImpl handlerChain;
    private ProtocolHandlerLoader loader;
    private HierarchicalConfiguration config;

    @Resource(name="protocolhandlerloader")
    public void setProtocolHandlerLoader(ProtocolHandlerLoader loader) {
        this.loader = loader;
    }

    @Override
    protected void preInit() throws Exception {
        super.preInit();
        this.handlerChain = new ProtocolHandlerChainImpl(this.loader, (HierarchicalConfiguration)this.config.configurationAt("handlerchain"), this.jmxName, this.getCoreHandlersPackage(), this.getJMXHandlersPackage());
        this.handlerChain.init();
    }

    @Override
    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        super.doConfigure(config);
        this.config = config;
    }

    @Override
    protected void postDestroy() {
        super.postDestroy();
        this.handlerChain.destroy();
    }

    protected ProtocolHandlerChain getProtocolHandlerChain() {
        return this.handlerChain;
    }

    protected abstract Class<? extends HandlersPackage> getCoreHandlersPackage();

    protected abstract Class<? extends HandlersPackage> getJMXHandlersPackage();
}

