/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public abstract class AbstractNotify
extends AbstractRedirect {
    @Override
    protected boolean getPassThrough() throws MessagingException {
        return Boolean.valueOf(this.getInitParameter("passThrough", "true"));
    }

    @Override
    protected int getInLineType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("inline", "none"));
    }

    @Override
    protected int getAttachmentType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("attachment", "message"));
    }

    @Override
    protected String getMessage() {
        return this.getInitParameter("notice", this.getInitParameter("message", "We were unable to deliver the attached message because of an error in the mail server."));
    }

    @Override
    protected String getMessage(Mail originalMail) throws MessagingException {
        int i;
        MimeMessage message = originalMail.getMessage();
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        out.println(this.getMessage());
        if (originalMail.getErrorMessage() != null) {
            out.println();
            out.println("Error message below:");
            out.println(originalMail.getErrorMessage());
        }
        out.println();
        out.println("Message details:");
        if (message.getSubject() != null) {
            out.println("  Subject: " + message.getSubject());
        }
        if (message.getSentDate() != null) {
            out.println("  Sent date: " + message.getSentDate());
        }
        out.println("  MAIL FROM: " + originalMail.getSender());
        Iterator rcptTo = originalMail.getRecipients().iterator();
        out.println("  RCPT TO: " + rcptTo.next());
        while (rcptTo.hasNext()) {
            out.println("           " + rcptTo.next());
        }
        String[] addresses = null;
        addresses = message.getHeader("From");
        if (addresses != null) {
            out.print("  From: ");
            for (i = 0; i < addresses.length; ++i) {
                out.print(addresses[i] + " ");
            }
            out.println();
        }
        if ((addresses = message.getHeader("To")) != null) {
            out.print("  To: ");
            for (i = 0; i < addresses.length; ++i) {
                out.print(addresses[i] + " ");
            }
            out.println();
        }
        if ((addresses = message.getHeader("Cc")) != null) {
            out.print("  CC: ");
            for (i = 0; i < addresses.length; ++i) {
                out.print(addresses[i] + " ");
            }
            out.println();
        }
        out.println("  Size (in bytes): " + message.getSize());
        if (message.getLineCount() >= 0) {
            out.println("  Number of lines: " + message.getLineCount());
        }
        return sout.toString();
    }

    @Override
    protected abstract Collection getRecipients() throws MessagingException;

    @Override
    protected InternetAddress[] getTo() throws MessagingException {
        return null;
    }

    @Override
    protected MailAddress getReplyTo() throws MessagingException {
        return AbstractRedirect.SpecialAddress.NULL;
    }

    @Override
    protected MailAddress getReversePath(Mail originalMail) throws MessagingException {
        return this.getSender(originalMail);
    }

    @Override
    protected MailAddress getSender() throws MessagingException {
        String addressString = this.getInitParameter("sendingAddress", this.getInitParameter("sender"));
        if (addressString == null) {
            return this.getMailetContext().getPostmaster();
        }
        MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "unaltered"});
        if (specialAddress != null) {
            return specialAddress;
        }
        try {
            return new MailAddress(addressString);
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getSender() parsing: " + addressString, e);
        }
    }

    @Override
    protected String getSubject() throws MessagingException {
        return null;
    }

    @Override
    protected String getSubjectPrefix() {
        return this.getInitParameter("prefix", "Re:");
    }

    @Override
    protected void setSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        String subject = originalMail.getMessage().getSubject();
        if (subject == null) {
            subject = "";
        }
        if (subjectPrefix == null || subject.indexOf(subjectPrefix) == 0) {
            newMail.getMessage().setSubject(subject);
        } else {
            newMail.getMessage().setSubject(subjectPrefix + subject);
        }
    }

    @Override
    protected boolean isReply() {
        return true;
    }
}

