/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public abstract class AbstractRecipientRewriteTableMailet
extends GenericMailet {
    private DomainList domainList;

    @Resource(name="domainlist")
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void service(Mail mail) throws MessagingException {
        Collection recipients = mail.getRecipients();
        Vector<MailAddress> errors = new Vector<MailAddress>();
        MimeMessage message = mail.getMessage();
        message.setHeader("Return-Path", mail.getSender() == null ? "<>" : "<" + mail.getSender() + ">");
        LinkedList<MailAddress> newRecipients = new LinkedList<MailAddress>();
        Iterator i = recipients.iterator();
        while (i.hasNext()) {
            MailAddress recipient = (MailAddress)i.next();
            try {
                Collection<MailAddress> usernames = this.processMail(mail.getSender(), recipient, message);
                if (usernames == null) {
                    i.remove();
                    continue;
                }
                i.remove();
                newRecipients.addAll(usernames);
            }
            catch (Exception ex) {
                this.getMailetContext().log("Error while storing mail.", (Throwable)ex);
                errors.add(recipient);
            }
        }
        if (newRecipients.size() > 0) {
            recipients.addAll(newRecipients);
        }
        if (!errors.isEmpty()) {
            this.getMailetContext().sendMail(mail.getSender(), errors, message, "error");
        }
        if (recipients.size() == 0) {
            mail.setState("ghost");
        }
    }

    protected Collection<MailAddress> handleMappings(Collection<String> mappings, MailAddress sender, MailAddress recipient, MimeMessage message) throws MessagingException {
        Iterator<String> i = mappings.iterator();
        ArrayList<MailAddress> remoteRecipients = new ArrayList<MailAddress>();
        ArrayList<MailAddress> localRecipients = new ArrayList<MailAddress>();
        while (i.hasNext()) {
            String rcpt = i.next();
            if (rcpt.indexOf("@") < 0) {
                try {
                    rcpt = rcpt + "@" + this.domainList.getDefaultDomain();
                }
                catch (DomainListException e) {
                    throw new MessagingException("Unable to access DomainList", (Exception)((Object)e));
                }
            }
            MailAddress nextMap = new MailAddress(rcpt);
            if (this.getMailetContext().isLocalServer(nextMap.getDomain())) {
                localRecipients.add(nextMap);
                continue;
            }
            remoteRecipients.add(nextMap);
        }
        if (remoteRecipients.size() > 0) {
            try {
                this.getMailetContext().sendMail(sender, remoteRecipients, message);
                StringBuffer logBuffer = new StringBuffer(128).append("Mail for ").append(recipient).append(" forwarded to ");
                Iterator j = remoteRecipients.iterator();
                while (j.hasNext()) {
                    logBuffer.append(j.next());
                    if (!j.hasNext()) continue;
                    logBuffer.append(", ");
                }
                this.getMailetContext().log(logBuffer.toString());
                return null;
            }
            catch (MessagingException me) {
                StringBuffer logBuffer = new StringBuffer(128).append("Error forwarding mail to ");
                Iterator j = remoteRecipients.iterator();
                while (j.hasNext()) {
                    logBuffer.append(j.next());
                    if (!j.hasNext()) continue;
                    logBuffer.append(", ");
                }
                logBuffer.append("attempting local delivery");
                this.getMailetContext().log(logBuffer.toString());
                throw me;
            }
        }
        if (localRecipients.size() > 0) {
            return localRecipients;
        }
        return null;
    }

    public abstract Collection<MailAddress> processMail(MailAddress var1, MailAddress var2, MimeMessage var3) throws MessagingException;
}

