/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailImpl;
import org.apache.james.core.MimeMessageUtil;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.RFC822DateFormat;

public abstract class AbstractRedirect
extends GenericMailet {
    protected boolean isDebug = false;
    protected boolean isStatic = false;
    protected static final int UNALTERED = 0;
    protected static final int HEADS = 1;
    protected static final int BODY = 2;
    protected static final int ALL = 3;
    protected static final int NONE = 4;
    protected static final int MESSAGE = 5;
    private boolean passThrough = false;
    private boolean fakeDomainCheck = true;
    private int attachmentType = 4;
    private int inLineType = 2;
    private String messageText;
    private Collection recipients;
    private MailAddress replyTo;
    private MailAddress reversePath;
    private MailAddress sender;
    private String subject;
    private String subjectPrefix;
    private InternetAddress[] apparentlyTo;
    private boolean attachError = false;
    private boolean isReply = false;
    private RFC822DateFormat rfc822DateFormat = new RFC822DateFormat();
    protected DNSService dns;

    protected String[] getAllowedInitParameters() {
        return null;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    protected boolean isStatic() {
        return true;
    }

    protected boolean getPassThrough() throws MessagingException {
        return Boolean.valueOf(this.getInitParameter("passThrough"));
    }

    protected boolean getPassThrough(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.passThrough : this.getPassThrough();
    }

    protected boolean getFakeDomainCheck() throws MessagingException {
        return Boolean.valueOf(this.getInitParameter("fakeDomainCheck"));
    }

    protected boolean getFakeDomainCheck(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.fakeDomainCheck : this.getFakeDomainCheck();
    }

    protected int getInLineType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("inline", "unaltered"));
    }

    protected int getInLineType(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.inLineType : this.getInLineType();
    }

    protected int getAttachmentType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("attachment", "none"));
    }

    protected int getAttachmentType(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.attachmentType : this.getAttachmentType();
    }

    protected String getMessage() throws MessagingException {
        return this.getInitParameter("message", "");
    }

    protected String getMessage(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.messageText : this.getMessage();
    }

    protected Collection getRecipients() throws MessagingException {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        String addressList = this.getInitParameter("recipients");
        if (addressList == null) {
            return null;
        }
        try {
            InternetAddress[] iaarray = InternetAddress.parse((String)addressList, (boolean)false);
            for (int i = 0; i < iaarray.length; ++i) {
                String addressString = iaarray[i].getAddress();
                MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "from", "replyTo", "reversePath", "unaltered", "recipients", "to", "null"});
                if (specialAddress != null) {
                    newRecipients.add(specialAddress);
                    continue;
                }
                newRecipients.add(new MailAddress(iaarray[i]));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getRecipients() parsing: " + addressList, e);
        }
        if (newRecipients.size() == 0) {
            throw new MessagingException("Failed to initialize \"recipients\" list; empty <recipients> init parameter found.");
        }
        return newRecipients;
    }

    protected Collection getRecipients(Mail originalMail) throws MessagingException {
        Collection recipients;
        Collection collection = recipients = this.isStatic() ? this.recipients : this.getRecipients();
        if (recipients != null) {
            recipients = recipients.size() == 1 && (recipients.contains(SpecialAddress.UNALTERED) || recipients.contains(SpecialAddress.RECIPIENTS)) ? null : this.replaceMailAddresses(originalMail, recipients);
        }
        return recipients;
    }

    protected void setRecipients(Mail newMail, Collection recipients, Mail originalMail) throws MessagingException {
        if (recipients != null) {
            newMail.setRecipients(recipients);
            if (this.isDebug) {
                this.log("recipients set to: " + this.arrayToString(recipients.toArray()));
            }
        }
    }

    protected InternetAddress[] getTo() throws MessagingException {
        InternetAddress[] iaarray = null;
        String addressList = this.getInitParameter("to");
        if (addressList == null) {
            return null;
        }
        try {
            iaarray = InternetAddress.parse((String)addressList, (boolean)false);
            for (int i = 0; i < iaarray.length; ++i) {
                String addressString = iaarray[i].getAddress();
                MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "from", "replyTo", "reversePath", "unaltered", "recipients", "to", "null"});
                if (specialAddress == null) continue;
                iaarray[i] = specialAddress.toInternetAddress();
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getTo() parsing: " + addressList, e);
        }
        if (iaarray.length == 0) {
            throw new MessagingException("Failed to initialize \"to\" list; empty <to> init parameter found.");
        }
        return iaarray;
    }

    protected InternetAddress[] getTo(Mail originalMail) throws MessagingException {
        InternetAddress[] apparentlyTo;
        InternetAddress[] internetAddressArray = apparentlyTo = this.isStatic() ? this.apparentlyTo : this.getTo();
        if (apparentlyTo != null) {
            if (apparentlyTo.length == 1 && (apparentlyTo[0].equals((Object)SpecialAddress.UNALTERED.toInternetAddress()) || apparentlyTo[0].equals((Object)SpecialAddress.TO.toInternetAddress()))) {
                apparentlyTo = null;
            } else {
                ArrayList<InternetAddress> toList = new ArrayList<InternetAddress>(apparentlyTo.length);
                for (int i = 0; i < apparentlyTo.length; ++i) {
                    toList.add(apparentlyTo[i]);
                }
                apparentlyTo = this.replaceInternetAddresses(originalMail, toList).toArray(new InternetAddress[0]);
            }
        }
        return apparentlyTo;
    }

    protected void setTo(Mail newMail, InternetAddress[] to, Mail originalMail) throws MessagingException {
        if (to != null) {
            newMail.getMessage().setRecipients(Message.RecipientType.TO, (Address[])to);
            if (this.isDebug) {
                this.log("apparentlyTo set to: " + this.arrayToString(to));
            }
        }
    }

    protected MailAddress getReplyTo() throws MessagingException {
        String addressString = this.getInitParameter("replyTo", this.getInitParameter("replyto"));
        if (addressString != null) {
            MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "null", "unaltered"});
            if (specialAddress != null) {
                return specialAddress;
            }
            try {
                return new MailAddress(addressString);
            }
            catch (Exception e) {
                throw new MessagingException("Exception thrown in getReplyTo() parsing: " + addressString, e);
            }
        }
        return null;
    }

    protected MailAddress getReplyTo(Mail originalMail) throws MessagingException {
        MailAddress replyTo;
        MailAddress mailAddress = replyTo = this.isStatic() ? this.replyTo : this.getReplyTo();
        if (replyTo != null) {
            if (replyTo == SpecialAddress.UNALTERED) {
                replyTo = null;
            } else if (replyTo == SpecialAddress.SENDER) {
                replyTo = originalMail.getSender();
            }
        }
        return replyTo;
    }

    protected void setReplyTo(Mail newMail, MailAddress replyTo, Mail originalMail) throws MessagingException {
        if (replyTo != null) {
            InternetAddress[] iart = null;
            if (replyTo != SpecialAddress.NULL) {
                iart = new InternetAddress[]{replyTo.toInternetAddress()};
            }
            newMail.getMessage().setReplyTo((Address[])iart);
            if (this.isDebug) {
                this.log("replyTo set to: " + replyTo);
            }
        }
    }

    protected MailAddress getReversePath() throws MessagingException {
        String addressString = this.getInitParameter("reversePath");
        if (addressString != null) {
            MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "null", "unaltered"});
            if (specialAddress != null) {
                return specialAddress;
            }
            try {
                return new MailAddress(addressString);
            }
            catch (Exception e) {
                throw new MessagingException("Exception thrown in getReversePath() parsing: " + addressString, e);
            }
        }
        return null;
    }

    protected MailAddress getReversePath(Mail originalMail) throws MessagingException {
        MailAddress reversePath;
        MailAddress mailAddress = reversePath = this.isStatic() ? this.reversePath : this.getReversePath();
        if (reversePath != null) {
            if (reversePath == SpecialAddress.UNALTERED || reversePath == SpecialAddress.REVERSE_PATH) {
                reversePath = null;
            } else if (reversePath == SpecialAddress.SENDER) {
                reversePath = null;
            }
        }
        return reversePath;
    }

    protected void setReversePath(MailImpl newMail, MailAddress reversePath, Mail originalMail) throws MessagingException {
        if (reversePath != null) {
            if (reversePath == SpecialAddress.NULL) {
                reversePath = null;
            }
            newMail.setSender(reversePath);
            if (this.isDebug) {
                this.log("reversePath set to: " + reversePath);
            }
        }
    }

    protected MailAddress getSender() throws MessagingException {
        String addressString = this.getInitParameter("sender");
        if (addressString != null) {
            MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "unaltered"});
            if (specialAddress != null) {
                return specialAddress;
            }
            try {
                return new MailAddress(addressString);
            }
            catch (Exception e) {
                throw new MessagingException("Exception thrown in getSender() parsing: " + addressString, e);
            }
        }
        return null;
    }

    protected MailAddress getSender(Mail originalMail) throws MessagingException {
        MailAddress sender;
        MailAddress mailAddress = sender = this.isStatic() ? this.sender : this.getSender();
        if (sender != null && (sender == SpecialAddress.UNALTERED || sender == SpecialAddress.SENDER)) {
            sender = null;
        }
        return sender;
    }

    protected void setSender(Mail newMail, MailAddress sender, Mail originalMail) throws MessagingException {
        if (sender != null) {
            newMail.getMessage().setFrom((Address)sender.toInternetAddress());
            if (this.isDebug) {
                this.log("sender set to: " + sender);
            }
        }
    }

    protected String getSubject() throws MessagingException {
        return this.getInitParameter("subject");
    }

    protected String getSubject(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.subject : this.getSubject();
    }

    protected String getSubjectPrefix() throws MessagingException {
        return this.getInitParameter("prefix");
    }

    protected String getSubjectPrefix(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.subjectPrefix : this.getSubjectPrefix();
    }

    protected void setSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        String subject = this.getSubject(originalMail);
        if (subjectPrefix != null && subjectPrefix.length() > 0 || subject != null) {
            if (subject == null) {
                subject = originalMail.getMessage().getSubject();
            } else if (this.isDebug) {
                this.log("subject set to: " + subject);
            }
            if (subject == null) {
                subject = "";
            }
            if (subjectPrefix != null) {
                subject = subjectPrefix + subject;
                if (this.isDebug) {
                    this.log("subjectPrefix set to: " + subjectPrefix);
                }
            }
            AbstractRedirect.changeSubject(newMail.getMessage(), subject);
        }
    }

    protected boolean attachError() throws MessagingException {
        return Boolean.valueOf(this.getInitParameter("attachError"));
    }

    protected boolean attachError(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.attachError : this.attachError();
    }

    protected boolean isReply() throws MessagingException {
        return Boolean.valueOf(this.getInitParameter("isReply"));
    }

    protected boolean isReply(Mail originalMail) throws MessagingException {
        return this.isStatic() ? this.isReply : this.isReply();
    }

    protected void setIsReply(Mail newMail, boolean isReply, Mail originalMail) throws MessagingException {
        String messageId;
        if (isReply && (messageId = originalMail.getMessage().getMessageID()) != null) {
            newMail.getMessage().setHeader("In-Reply-To", messageId);
            if (this.isDebug) {
                this.log("IN_REPLY_TO set to: " + messageId);
            }
        }
    }

    public void init() throws MessagingException {
        this.isDebug = Boolean.valueOf(this.getInitParameter("debug", "false"));
        this.isStatic = Boolean.valueOf(this.getInitParameter("static", "false"));
        if (this.isDebug) {
            this.log("Initializing");
        }
        this.checkInitParameters(this.getAllowedInitParameters());
        if (this.isStatic()) {
            this.passThrough = this.getPassThrough();
            this.fakeDomainCheck = this.getFakeDomainCheck();
            this.attachmentType = this.getAttachmentType();
            this.inLineType = this.getInLineType();
            this.messageText = this.getMessage();
            this.recipients = this.getRecipients();
            this.replyTo = this.getReplyTo();
            this.reversePath = this.getReversePath();
            this.sender = this.getSender();
            this.subject = this.getSubject();
            this.subjectPrefix = this.getSubjectPrefix();
            this.apparentlyTo = this.getTo();
            this.attachError = this.attachError();
            this.isReply = this.isReply();
            if (this.isDebug) {
                StringBuffer logBuffer = new StringBuffer(1024).append("static").append(", passThrough=").append(this.passThrough).append(", fakeDomainCheck=").append(this.fakeDomainCheck).append(", sender=").append(this.sender).append(", replyTo=").append(this.replyTo).append(", reversePath=").append(this.reversePath).append(", message=").append(this.messageText).append(", recipients=").append(this.arrayToString(this.recipients == null ? null : this.recipients.toArray())).append(", subject=").append(this.subject).append(", subjectPrefix=").append(this.subjectPrefix).append(", apparentlyTo=").append(this.arrayToString(this.apparentlyTo)).append(", attachError=").append(this.attachError).append(", isReply=").append(this.isReply).append(", attachmentType=").append(this.attachmentType).append(", inLineType=").append(this.inLineType).append(" ");
                this.log(logBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail originalMail) throws MessagingException {
        block17: {
            boolean keepMessageId = false;
            MailImpl newMail = new MailImpl(originalMail);
            try {
                try {
                    newMail.setRemoteAddr(this.dns.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    newMail.setRemoteAddr("127.0.0.1");
                }
                try {
                    newMail.setRemoteHost(this.dns.getLocalHost().getHostName());
                }
                catch (UnknownHostException e) {
                    newMail.setRemoteHost("localhost");
                }
                if (this.isDebug) {
                    this.log("New mail - sender: " + newMail.getSender() + ", recipients: " + this.arrayToString(newMail.getRecipients().toArray()) + ", name: " + newMail.getName() + ", remoteHost: " + newMail.getRemoteHost() + ", remoteAddr: " + newMail.getRemoteAddr() + ", state: " + newMail.getState() + ", lastUpdated: " + newMail.getLastUpdated() + ", errorMessage: " + newMail.getErrorMessage());
                }
                if (this.getInLineType(originalMail) != 0) {
                    if (this.isDebug) {
                        this.log("Alter message");
                    }
                    newMail.setMessage(new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null)));
                    this.buildAlteredMessage((Mail)newMail, originalMail);
                } else {
                    if (this.getPassThrough(originalMail)) {
                        newMail.setMessage(new MimeMessage(originalMail.getMessage()){

                            protected void updateHeaders() throws MessagingException {
                                if (this.getMessageID() == null) {
                                    super.updateHeaders();
                                } else {
                                    this.modified = false;
                                }
                            }
                        });
                    }
                    if (this.isDebug) {
                        this.log("Message resent unaltered.");
                    }
                    keepMessageId = true;
                }
                this.setRecipients((Mail)newMail, this.getRecipients(originalMail), originalMail);
                this.setTo((Mail)newMail, this.getTo(originalMail), originalMail);
                this.setSubjectPrefix((Mail)newMail, this.getSubjectPrefix(originalMail), originalMail);
                if (newMail.getMessage().getHeader("Date") == null) {
                    newMail.getMessage().setHeader("Date", this.rfc822DateFormat.format(new Date()));
                }
                this.setReplyTo((Mail)newMail, this.getReplyTo(originalMail), originalMail);
                this.setReversePath(newMail, this.getReversePath(originalMail), originalMail);
                this.setSender((Mail)newMail, this.getSender(originalMail), originalMail);
                this.setIsReply((Mail)newMail, this.isReply(originalMail), originalMail);
                newMail.getMessage().saveChanges();
                if (keepMessageId) {
                    this.setMessageId((Mail)newMail, originalMail);
                }
                if (this.senderDomainIsValid((Mail)newMail)) {
                    this.getMailetContext().sendMail((Mail)newMail);
                    break block17;
                }
                StringBuffer logBuffer = new StringBuffer(256).append(this.getMailetName()).append(" mailet cannot forward ").append(originalMail.getName()).append(". Invalid sender domain for ").append(newMail.getSender()).append(". Consider using the Resend mailet ").append("using a different sender.");
                throw new MessagingException(logBuffer.toString());
            }
            finally {
                newMail.dispose();
            }
        }
        if (!this.getPassThrough(originalMail)) {
            originalMail.setState("ghost");
        }
    }

    protected int getTypeCode(String param) {
        if ((param = param.toLowerCase(Locale.US)).compareTo("unaltered") == 0) {
            return 0;
        }
        if (param.compareTo("heads") == 0) {
            return 1;
        }
        if (param.compareTo("body") == 0) {
            return 2;
        }
        if (param.compareTo("all") == 0) {
            return 3;
        }
        if (param.compareTo("none") == 0) {
            return 4;
        }
        if (param.compareTo("message") == 0) {
            return 5;
        }
        return 4;
    }

    protected String getMessageHeaders(MimeMessage message) throws MessagingException {
        Enumeration heads = message.getAllHeaderLines();
        StringBuffer headBuffer = new StringBuffer(1024);
        while (heads.hasMoreElements()) {
            headBuffer.append(heads.nextElement().toString()).append("\r\n");
        }
        return headBuffer.toString();
    }

    private String getMessageBody(MimeMessage message) throws Exception {
        ByteArrayOutputStream bodyOs = new ByteArrayOutputStream();
        MimeMessageUtil.writeMessageBodyTo((MimeMessage)message, (OutputStream)bodyOs);
        return bodyOs.toString();
    }

    protected void buildAlteredMessage(Mail newMail, Mail originalMail) throws MessagingException {
        MimeMessage originalMessage = originalMail.getMessage();
        MimeMessage newMessage = newMail.getMessage();
        String[] relevantHeaderNames = new String[]{"Date", "From", "Reply-To", "To", "Subject", "Return-Path"};
        Enumeration headerEnum = originalMessage.getMatchingHeaderLines(relevantHeaderNames);
        while (headerEnum.hasMoreElements()) {
            newMessage.addHeaderLine((String)headerEnum.nextElement());
        }
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        String head = this.getMessageHeaders(originalMessage);
        boolean all = false;
        String messageText = this.getMessage(originalMail);
        if (messageText != null) {
            out.println(messageText);
        }
        if (this.isDebug) {
            this.log("inline:" + this.getInLineType(originalMail));
        }
        switch (this.getInLineType(originalMail)) {
            case 3: {
                all = true;
            }
            case 1: {
                out.println("Message Headers:");
                out.println(head);
                if (!all) break;
            }
            case 2: {
                out.println("Message:");
                try {
                    out.println(this.getMessageBody(originalMessage));
                }
                catch (Exception e) {
                    out.println("body unavailable");
                }
                break;
            }
        }
        try {
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeMultipart mpContent = new MimeMultipart("alternative");
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            contentPartRoot.setContent((Multipart)mpContent);
            multipart.addBodyPart((BodyPart)contentPartRoot);
            MimeBodyPart part = new MimeBodyPart();
            part.setText(sout.toString());
            part.setDisposition("inline");
            mpContent.addBodyPart((BodyPart)part);
            if (this.isDebug) {
                this.log("attachmentType:" + this.getAttachmentType(originalMail));
            }
            if (this.getAttachmentType(originalMail) != 4) {
                part = new MimeBodyPart();
                switch (this.getAttachmentType(originalMail)) {
                    case 1: {
                        part.setText(head);
                        break;
                    }
                    case 2: {
                        try {
                            part.setText(this.getMessageBody(originalMessage));
                        }
                        catch (Exception e) {
                            part.setText("body unavailable");
                        }
                        break;
                    }
                    case 3: {
                        StringBuffer textBuffer = new StringBuffer(1024).append(head).append("\r\nMessage:\r\n").append(this.getMessageBody(originalMessage));
                        part.setText(textBuffer.toString());
                        break;
                    }
                    case 5: {
                        part.setContent((Object)originalMessage, "message/rfc822");
                    }
                }
                if (originalMessage.getSubject() != null && originalMessage.getSubject().trim().length() > 0) {
                    part.setFileName(originalMessage.getSubject().trim());
                } else {
                    part.setFileName("No Subject");
                }
                part.setDisposition("Attachment");
                multipart.addBodyPart((BodyPart)part);
            }
            if (this.attachError(originalMail) && originalMail.getErrorMessage() != null) {
                part = new MimeBodyPart();
                part.setContent((Object)originalMail.getErrorMessage(), "text/plain");
                part.setHeader("Content-Type", "text/plain");
                part.setFileName("Reasons");
                part.setDisposition("attachment");
                multipart.addBodyPart((BodyPart)part);
            }
            newMail.getMessage().setContent((Multipart)multipart);
            newMail.getMessage().setHeader("Content-Type", multipart.getContentType());
        }
        catch (Exception ioe) {
            throw new MessagingException("Unable to create multipart body", ioe);
        }
    }

    private void setMessageId(Mail newMail, Mail originalMail) throws MessagingException {
        String messageId = originalMail.getMessage().getMessageID();
        if (messageId != null) {
            newMail.getMessage().setHeader("Message-ID", messageId);
            if (this.isDebug) {
                this.log("MESSAGE_ID restored to: " + messageId);
            }
        }
    }

    protected final MailAddress getSpecialAddress(String addressString, String[] allowedSpecials) throws MessagingException {
        if (addressString == null) {
            return null;
        }
        addressString = addressString.toLowerCase(Locale.US);
        addressString = addressString.trim();
        MailAddress specialAddress = null;
        if (addressString.compareTo("postmaster") == 0) {
            specialAddress = this.getMailetContext().getPostmaster();
        }
        if (addressString.compareTo("sender") == 0) {
            specialAddress = SpecialAddress.SENDER;
        }
        if (addressString.compareTo("reversepath") == 0) {
            specialAddress = SpecialAddress.REVERSE_PATH;
        }
        if (addressString.compareTo("from") == 0) {
            specialAddress = SpecialAddress.FROM;
        }
        if (addressString.compareTo("replyto") == 0) {
            specialAddress = SpecialAddress.REPLY_TO;
        }
        if (addressString.compareTo("to") == 0) {
            specialAddress = SpecialAddress.TO;
        }
        if (addressString.compareTo("recipients") == 0) {
            specialAddress = SpecialAddress.RECIPIENTS;
        }
        if (addressString.compareTo("delete") == 0) {
            specialAddress = SpecialAddress.DELETE;
        }
        if (addressString.compareTo("unaltered") == 0) {
            specialAddress = SpecialAddress.UNALTERED;
        }
        if (addressString.compareTo("null") == 0) {
            specialAddress = SpecialAddress.NULL;
        }
        if (specialAddress != null) {
            boolean allowed = false;
            for (int i = 0; i < allowedSpecials.length; ++i) {
                String allowedSpecial = allowedSpecials[i];
                allowedSpecial = allowedSpecial.toLowerCase(Locale.US);
                if (addressString.compareTo(allowedSpecial = allowedSpecial.trim()) != 0) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new MessagingException("Special (\"magic\") address found not allowed: " + addressString + ", allowed values are \"" + this.arrayToString(allowedSpecials) + "\"");
            }
        }
        return specialAddress;
    }

    protected final boolean senderDomainIsValid(Mail mail) throws MessagingException {
        if (this.getFakeDomainCheck(mail)) {
            return mail.getSender() == null || this.getMailetContext().getMailServers(mail.getSender().getDomain()).size() != 0;
        }
        return true;
    }

    public static void changeSubject(MimeMessage message, String newValue) throws MessagingException {
        String rawSubject = message.getHeader("Subject", null);
        String mimeCharset = AbstractRedirect.determineMailHeaderEncodingCharset(rawSubject);
        if (mimeCharset == null) {
            message.setSubject(newValue);
            return;
        }
        String javaCharset = MimeUtility.javaCharset((String)mimeCharset);
        try {
            message.setSubject(newValue, javaCharset);
        }
        catch (MessagingException e) {
            message.setSubject(newValue);
        }
    }

    private static String determineMailHeaderEncodingCharset(String rawText) {
        if (rawText == null) {
            return null;
        }
        int iEncodingPrefix = rawText.indexOf("=?");
        if (iEncodingPrefix == -1) {
            return null;
        }
        int iCharsetBegin = iEncodingPrefix + 2;
        int iSecondQuestionMark = rawText.indexOf(63, iCharsetBegin);
        if (iSecondQuestionMark == -1) {
            return null;
        }
        if (iSecondQuestionMark == iCharsetBegin) {
            return null;
        }
        int iThirdQuestionMark = rawText.indexOf(63, iSecondQuestionMark + 1);
        if (iThirdQuestionMark == -1) {
            return null;
        }
        if (-1 == rawText.indexOf("?=", iThirdQuestionMark + 1)) {
            return null;
        }
        String mimeCharset = rawText.substring(iCharsetBegin, iSecondQuestionMark);
        return mimeCharset;
    }

    protected Collection replaceMailAddresses(Mail mail, Collection list) {
        HashSet<MailAddress> newList = new HashSet<MailAddress>(list.size());
        for (MailAddress mailAddress : list) {
            if (!mailAddress.getDomain().equalsIgnoreCase("address.marker")) {
                newList.add(mailAddress);
                continue;
            }
            if (mailAddress == SpecialAddress.SENDER || mailAddress == SpecialAddress.FROM) {
                MailAddress sender = mail.getSender();
                if (sender == null) continue;
                newList.add(sender);
                continue;
            }
            if (mailAddress == SpecialAddress.REPLY_TO) {
                MailAddress sender;
                int parsedAddressCount = 0;
                try {
                    InternetAddress[] replyToArray = (InternetAddress[])mail.getMessage().getReplyTo();
                    if (replyToArray != null) {
                        for (int i = 0; i < replyToArray.length; ++i) {
                            try {
                                newList.add(new MailAddress(replyToArray[i]));
                                ++parsedAddressCount;
                                continue;
                            }
                            catch (ParseException pe) {
                                this.log("Unable to parse a \"REPLY_TO\" header address in the original message: " + replyToArray[i] + "; ignoring.");
                            }
                        }
                    }
                }
                catch (MessagingException ae) {
                    this.log("Unable to parse the \"REPLY_TO\" header in the original message; ignoring.");
                }
                if (parsedAddressCount != 0 || (sender = mail.getSender()) == null) continue;
                newList.add(sender);
                continue;
            }
            if (mailAddress == SpecialAddress.REVERSE_PATH) {
                MailAddress reversePath = mail.getSender();
                if (reversePath == null) continue;
                newList.add(reversePath);
                continue;
            }
            if (mailAddress == SpecialAddress.RECIPIENTS || mailAddress == SpecialAddress.TO) {
                newList.addAll(mail.getRecipients());
                continue;
            }
            if (mailAddress == SpecialAddress.UNALTERED || mailAddress == SpecialAddress.NULL) continue;
            newList.add(mailAddress);
        }
        return newList;
    }

    protected Collection replaceInternetAddresses(Mail mail, Collection list) throws MessagingException {
        HashSet<InternetAddress> newList = new HashSet<InternetAddress>(list.size());
        for (InternetAddress internetAddress : list) {
            int i;
            MailAddress mailAddress = new MailAddress(internetAddress);
            if (!mailAddress.getDomain().equalsIgnoreCase("address.marker")) {
                newList.add(internetAddress);
                continue;
            }
            if (internetAddress.equals((Object)SpecialAddress.SENDER.toInternetAddress())) {
                MailAddress sender = mail.getSender();
                if (sender == null) continue;
                newList.add(sender.toInternetAddress());
                continue;
            }
            if (internetAddress.equals((Object)SpecialAddress.REVERSE_PATH.toInternetAddress())) {
                MailAddress reversePath = mail.getSender();
                if (reversePath == null) continue;
                newList.add(reversePath.toInternetAddress());
                continue;
            }
            if (internetAddress.equals((Object)SpecialAddress.FROM.toInternetAddress())) {
                try {
                    InternetAddress[] fromArray = (InternetAddress[])mail.getMessage().getFrom();
                    if (fromArray != null) {
                        for (i = 0; i < fromArray.length; ++i) {
                            newList.add(fromArray[i]);
                        }
                        continue;
                    }
                    MailAddress reversePath = mail.getSender();
                    if (reversePath == null) continue;
                    newList.add(reversePath.toInternetAddress());
                }
                catch (MessagingException me) {
                    this.log("Unable to parse the \"FROM\" header in the original message; ignoring.");
                }
                continue;
            }
            if (internetAddress.equals((Object)SpecialAddress.REPLY_TO.toInternetAddress())) {
                try {
                    InternetAddress[] replyToArray = (InternetAddress[])mail.getMessage().getReplyTo();
                    if (replyToArray != null) {
                        for (i = 0; i < replyToArray.length; ++i) {
                            newList.add(replyToArray[i]);
                        }
                        continue;
                    }
                    MailAddress reversePath = mail.getSender();
                    if (reversePath == null) continue;
                    newList.add(reversePath.toInternetAddress());
                }
                catch (MessagingException me) {
                    this.log("Unable to parse the \"REPLY_TO\" header in the original message; ignoring.");
                }
                continue;
            }
            if (internetAddress.equals((Object)SpecialAddress.TO.toInternetAddress()) || internetAddress.equals((Object)SpecialAddress.RECIPIENTS.toInternetAddress())) {
                try {
                    String[] toHeaders = mail.getMessage().getHeader("To");
                    if (toHeaders == null) continue;
                    for (i = 0; i < toHeaders.length; ++i) {
                        try {
                            InternetAddress[] originalToInternetAddresses = InternetAddress.parse((String)toHeaders[i], (boolean)false);
                            for (int j = 0; j < originalToInternetAddresses.length; ++j) {
                                newList.add(originalToInternetAddresses[j]);
                            }
                            continue;
                        }
                        catch (MessagingException ae) {
                            this.log("Unable to parse a \"TO\" header address in the original message: " + toHeaders[i] + "; ignoring.");
                        }
                    }
                    continue;
                }
                catch (MessagingException ae) {
                    this.log("Unable to parse the \"TO\" header  in the original message; ignoring.");
                    continue;
                }
            }
            if (internetAddress.equals((Object)SpecialAddress.UNALTERED.toInternetAddress()) || internetAddress.equals((Object)SpecialAddress.NULL.toInternetAddress())) continue;
            newList.add(internetAddress);
        }
        return newList;
    }

    protected static class SpecialAddress {
        public static final MailAddress SENDER = AddressMarker.SENDER;
        public static final MailAddress REVERSE_PATH = AddressMarker.REVERSE_PATH;
        public static final MailAddress FROM = AddressMarker.FROM;
        public static final MailAddress REPLY_TO = AddressMarker.REPLY_TO;
        public static final MailAddress TO = AddressMarker.TO;
        public static final MailAddress RECIPIENTS = AddressMarker.RECIPIENTS;
        public static final MailAddress DELETE = AddressMarker.DELETE;
        public static final MailAddress UNALTERED = AddressMarker.UNALTERED;
        public static final MailAddress NULL = AddressMarker.NULL;

        protected SpecialAddress() {
        }
    }

    private static class AddressMarker {
        public static MailAddress SENDER;
        public static MailAddress REVERSE_PATH;
        public static MailAddress FROM;
        public static MailAddress REPLY_TO;
        public static MailAddress TO;
        public static MailAddress RECIPIENTS;
        public static MailAddress DELETE;
        public static MailAddress UNALTERED;
        public static MailAddress NULL;

        private AddressMarker() {
        }

        static {
            try {
                SENDER = new MailAddress("sender", "address.marker");
                REVERSE_PATH = new MailAddress("reverse.path", "address.marker");
                FROM = new MailAddress("from", "address.marker");
                REPLY_TO = new MailAddress("reply.to", "address.marker");
                TO = new MailAddress("to", "address.marker");
                RECIPIENTS = new MailAddress("recipients", "address.marker");
                DELETE = new MailAddress("delete", "address.marker");
                UNALTERED = new MailAddress("unaltered", "address.marker");
                NULL = new MailAddress("null", "address.marker");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

