/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.sql.DataSource;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.util.bayesian.JDBCBayesianAnalyzer;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public class BayesianAnalysis
extends GenericMailet {
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            BayesianAnalysis.this.log("BayesianAnalysis: " + logString);
        }
    };
    private JDBCBayesianAnalyzer analyzer = new JDBCBayesianAnalyzer(){

        protected void delegatedLog(String logString) {
            BayesianAnalysis.this.log("BayesianAnalysis: " + logString);
        }
    };
    private DataSource datasource;
    private String repositoryPath;
    private static final String MAIL_ATTRIBUTE_NAME = "org.apache.james.spam.probability";
    private static final String HEADER_NAME = "X-MessageIsSpamProbability";
    private static final long CORPUS_RELOAD_INTERVAL = 600000L;
    private String headerName;
    private boolean ignoreLocalSender = false;
    private boolean tagSubject = true;
    private int maxSize = 100000;
    private long lastCorpusLoadTime;
    private FileSystem fs;

    public String getMailetInfo() {
        return "BayesianAnalysis Mailet";
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public long getLastCorpusLoadTime() {
        return this.lastCorpusLoadTime;
    }

    @Resource(name="datasource")
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    private void touchLastCorpusLoadTime() {
        this.lastCorpusLoadTime = System.currentTimeMillis();
    }

    public void init() throws MessagingException {
        this.repositoryPath = this.getInitParameter("repositoryPath");
        if (this.repositoryPath == null) {
            throw new MessagingException("repositoryPath is null");
        }
        this.headerName = this.getInitParameter("headerName", HEADER_NAME);
        this.ignoreLocalSender = Boolean.valueOf(this.getInitParameter("ignoreLocalSender"));
        if (this.ignoreLocalSender) {
            this.log("Will ignore messages coming from local senders");
        } else {
            this.log("Will analyze messages coming from local senders");
        }
        String maxSizeParam = this.getInitParameter("maxSize");
        if (maxSizeParam != null) {
            this.setMaxSize(Integer.parseInt(maxSizeParam));
        }
        this.log("maxSize: " + this.getMaxSize());
        String tag = this.getInitParameter("tagSubject");
        if (tag != null && tag.equals("false")) {
            this.tagSubject = false;
        }
        this.initDb();
        CorpusLoader corpusLoader = new CorpusLoader(this);
        corpusLoader.setDaemon(true);
        corpusLoader.start();
    }

    private void initDb() throws MessagingException {
        try {
            this.analyzer.initSqlQueries(this.datasource.getConnection(), this.fs.getFile("file://conf/sqlResources.xml"));
        }
        catch (Exception e) {
            throw new MessagingException("Exception initializing queries", e);
        }
        try {
            this.loadData(this.datasource.getConnection());
        }
        catch (SQLException se) {
            throw new MessagingException("SQLException loading data", (Exception)se);
        }
    }

    public void service(Mail mail) throws MessagingException {
        try {
            double probability;
            MimeMessage message = mail.getMessage();
            if (this.ignoreLocalSender && mail.getSender() != null && this.getMailetContext().isLocalServer(mail.getSender().getDomain())) {
                return;
            }
            String[] headerArray = message.getHeader(this.headerName);
            if (headerArray != null && headerArray.length > 0) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (message.getSize() < this.getMaxSize()) {
                message.writeTo((OutputStream)baos);
                probability = this.analyzer.computeSpamProbability((Reader)new BufferedReader(new StringReader(baos.toString())));
            } else {
                probability = 0.0;
            }
            mail.setAttribute(MAIL_ATTRIBUTE_NAME, (Serializable)new Double(probability));
            message.setHeader(this.headerName, Double.toString(probability));
            DecimalFormat probabilityForm = (DecimalFormat)DecimalFormat.getInstance();
            probabilityForm.applyPattern("##0.##%");
            String probabilityString = probabilityForm.format(probability);
            String senderString = mail.getSender() == null ? "null" : mail.getSender().toString();
            if (probability > 0.1) {
                this.log(this.headerName + ": " + probabilityString + "; From: " + senderString + "; Recipient(s): " + this.getAddressesString(mail.getRecipients()));
                if (this.tagSubject) {
                    this.appendToSubject(message, " [" + probabilityString + (probability > 0.9 ? " SPAM" : " spam") + "]");
                }
            }
            this.saveChanges(message);
        }
        catch (Exception e) {
            this.log("Exception: " + e.getMessage(), e);
            throw new MessagingException("Exception thrown", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData(Connection conn) throws SQLException {
        try {
            String string = "database lock";
            synchronized ("database lock") {
                this.analyzer.tokenCountsClear();
                this.analyzer.loadHamNSpam(conn);
                this.analyzer.buildCorpus();
                this.analyzer.tokenCountsClear();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.log("BayesianAnalysis Corpus loaded");
                this.touchLastCorpusLoadTime();
            }
        }
        finally {
            if (conn != null) {
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
        {
            return;
        }
    }

    private String getAddressesString(Collection<MailAddress> addresses) {
        if (addresses == null) {
            return "null";
        }
        Iterator<MailAddress> iter = addresses.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = 0;
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (i + 1 < addresses.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private void appendToSubject(MimeMessage message, String toAppend) {
        try {
            String subject = message.getSubject();
            if (subject == null) {
                message.setSubject(toAppend, "iso-8859-1");
            } else {
                message.setSubject(toAppend + " " + subject, "iso-8859-1");
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void saveChanges(MimeMessage message) throws MessagingException {
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
    }

    private static class CorpusLoader
    extends Thread {
        private BayesianAnalysis analysis;

        private CorpusLoader(BayesianAnalysis analysis) {
            super("BayesianAnalysis Corpus Loader");
            this.analysis = analysis;
        }

        @Override
        public void run() {
            this.analysis.log("CorpusLoader thread started: will wake up every 600000 ms");
            try {
                Thread.sleep(600000L);
                while (true) {
                    if (this.analysis.getLastCorpusLoadTime() < JDBCBayesianAnalyzer.getLastDatabaseUpdateTime()) {
                        this.analysis.log("Reloading Corpus ...");
                        try {
                            this.analysis.loadData(this.analysis.datasource.getConnection());
                            this.analysis.log("Corpus reloaded");
                        }
                        catch (SQLException se) {
                            this.analysis.log("SQLException: ", se);
                        }
                    }
                    if (!Thread.interrupted()) {
                        Thread.sleep(600000L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }
}

