/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.AbstractNotify;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class Bounce
extends AbstractNotify {
    public String getMailetInfo() {
        return "Bounce Mailet";
    }

    @Override
    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"debug", "passThrough", "fakeDomainCheck", "inline", "attachment", "message", "notice", "sender", "sendingAddress", "prefix", "attachError"};
        return allowedArray;
    }

    @Override
    protected Collection getRecipients() {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        newRecipients.add(AbstractRedirect.SpecialAddress.REVERSE_PATH);
        return newRecipients;
    }

    @Override
    protected InternetAddress[] getTo() {
        InternetAddress[] apparentlyTo = new InternetAddress[]{AbstractRedirect.SpecialAddress.REVERSE_PATH.toInternetAddress()};
        return apparentlyTo;
    }

    @Override
    protected MailAddress getReversePath(Mail originalMail) {
        return AbstractRedirect.SpecialAddress.NULL;
    }

    @Override
    public void service(Mail originalMail) throws MessagingException {
        if (originalMail.getSender() == null) {
            if (this.isDebug) {
                this.log("Processing a bounce request for a message with an empty reverse-path.  No bounce will be sent.");
            }
            if (!this.getPassThrough(originalMail)) {
                originalMail.setState("ghost");
            }
            return;
        }
        if (this.isDebug) {
            this.log("Processing a bounce request for a message with a reverse path.  The bounce will be sent to " + originalMail.getSender().toString());
        }
        super.service(originalMail);
    }
}

