/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailImpl;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.transport.mailets.AbstractNotify;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.RFC822DateFormat;
import org.apache.mailet.base.mail.MimeMultipartReport;

public class DSNBounce
extends AbstractNotify {
    private static final RFC822DateFormat rfc822DateFormat = new RFC822DateFormat();
    private static Pattern statusPattern;
    private static Pattern diagPattern;
    private static final String MACHINE_PATTERN = "[machine]";
    private String messageString = null;

    @Override
    public void init() throws MessagingException {
        super.init();
        this.messageString = this.getInitParameter("messageString", "Hi. This is the James mail server at [machine].\nI'm afraid I wasn't able to deliver your message to the following addresses.\nThis is a permanent error; I've given up. Sorry it didn't work out.  Below\nI include the list of recipients and the reason why I was unable to deliver\nyour message.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Mail originalMail) throws MessagingException {
        MailImpl newMail = new MailImpl(originalMail);
        try {
            try {
                newMail.setRemoteAddr(this.dns.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                newMail.setRemoteHost("localhost");
            }
            try {
                newMail.setRemoteHost(this.dns.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                newMail.setRemoteAddr("127.0.0.1");
            }
            if (originalMail.getSender() == null) {
                if (this.isDebug) {
                    this.log("Processing a bounce request for a message with an empty reverse-path.  No bounce will be sent.");
                }
                if (!this.getPassThrough(originalMail)) {
                    originalMail.setState("ghost");
                }
                return;
            }
            MailAddress reversePath = originalMail.getSender();
            if (this.isDebug) {
                this.log("Processing a bounce request for a message with a reverse path.  The bounce will be sent to " + reversePath);
            }
            HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
            newRecipients.add(reversePath);
            newMail.setRecipients(newRecipients);
            if (this.isDebug) {
                this.log("New mail - sender: " + newMail.getSender() + ", recipients: " + this.arrayToString(newMail.getRecipients().toArray()) + ", name: " + newMail.getName() + ", remoteHost: " + newMail.getRemoteHost() + ", remoteAddr: " + newMail.getRemoteAddr() + ", state: " + newMail.getState() + ", lastUpdated: " + newMail.getLastUpdated() + ", errorMessage: " + newMail.getErrorMessage());
            }
            MimeMessage newMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null));
            MimeMultipartReport multipart = new MimeMultipartReport();
            multipart.setReportType("delivery-status");
            MimeBodyPart part1 = this.createTextMsg(originalMail);
            multipart.addBodyPart((BodyPart)part1);
            MimeBodyPart part2 = this.createDSN(originalMail);
            multipart.addBodyPart((BodyPart)part2);
            if (this.getAttachmentType() != 4) {
                MimeBodyPart part3 = this.createAttachedOriginal(originalMail, this.getAttachmentType());
                multipart.addBodyPart((BodyPart)part3);
            }
            newMessage.setContent((Multipart)multipart);
            newMessage.setHeader("Content-Type", multipart.getContentType());
            newMail.setMessage(newMessage);
            this.setRecipients((Mail)newMail, this.getRecipients(originalMail), originalMail);
            this.setTo((Mail)newMail, this.getTo(originalMail), originalMail);
            this.setSubjectPrefix((Mail)newMail, this.getSubjectPrefix(originalMail), originalMail);
            if (newMail.getMessage().getHeader("Date") == null) {
                newMail.getMessage().setHeader("Date", rfc822DateFormat.format(new Date()));
            }
            this.setReplyTo((Mail)newMail, this.getReplyTo(originalMail), originalMail);
            this.setReversePath(newMail, this.getReversePath(originalMail), originalMail);
            this.setSender((Mail)newMail, this.getSender(originalMail), originalMail);
            this.setIsReply((Mail)newMail, this.isReply(originalMail), originalMail);
            newMail.getMessage().saveChanges();
            this.getMailetContext().sendMail((Mail)newMail);
        }
        finally {
            newMail.dispose();
        }
        if (!this.getPassThrough(originalMail)) {
            originalMail.setState("ghost");
        }
    }

    protected MimeBodyPart createTextMsg(Mail originalMail) throws MessagingException {
        MimeBodyPart part1 = new MimeBodyPart();
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        String machine = "[unknown]";
        try {
            InetAddress me = InetAddress.getLocalHost();
            machine = me.getHostName();
        }
        catch (Exception e) {
            machine = "[address unknown]";
        }
        StringBuffer bounceBuffer = new StringBuffer(128).append(this.messageString);
        int m_idx_begin = this.messageString.indexOf(MACHINE_PATTERN);
        if (m_idx_begin != -1) {
            bounceBuffer.replace(m_idx_begin, m_idx_begin + MACHINE_PATTERN.length(), machine);
        }
        out.println(bounceBuffer.toString());
        out.println("Failed recipient(s):");
        Iterator i = originalMail.getRecipients().iterator();
        while (i.hasNext()) {
            out.println(i.next());
        }
        String ex = (String)((Object)originalMail.getAttribute("delivery-error"));
        out.println();
        out.println("Error message:");
        out.println(ex);
        out.println();
        part1.setText(sout.toString());
        return part1;
    }

    protected MimeBodyPart createDSN(Mail originalMail) throws MessagingException {
        MimeBodyPart dsn = new MimeBodyPart();
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        String nameType = null;
        nameType = "dns";
        try {
            String myAddress = this.dns.getHostName(this.dns.getLocalHost());
            out.println("Reporting-MTA: " + nameType + "; " + myAddress);
        }
        catch (Exception e) {
            this.log("WARNING: sending DSN without required Reporting-MTA Address");
        }
        out.println("Received-From-MTA: " + nameType + "; " + originalMail.getRemoteHost());
        for (MailAddress rec : originalMail.getRecipients()) {
            String addressType = "rfc822";
            out.println();
            out.println("Final-Recipient: " + addressType + "; " + rec.toString());
            out.println("Action: failed");
            String ex = (String)((Object)originalMail.getAttribute("delivery-error"));
            if (ex == null) {
                ex = "unknown";
            }
            out.println("Status: " + ex);
            String diagnosticType = null;
            String diagnosticCode = ex;
            boolean smtpDiagCodeAvailable = diagPattern.matcher(diagnosticCode).matches();
            diagnosticType = smtpDiagCodeAvailable ? "smtp" : "X-James";
            out.println("Diagnostic-Code: " + diagnosticType + "; " + diagnosticCode);
            out.println("Last-Attempt-Date: " + rfc822DateFormat.format(originalMail.getLastUpdated()));
        }
        dsn.setContent((Object)sout.toString(), "text/plain");
        dsn.setHeader("Content-Type", "message/delivery-status");
        dsn.setDescription("Delivery Status Notification");
        dsn.setFileName("status.dat");
        return dsn;
    }

    protected MimeBodyPart createAttachedOriginal(Mail originalMail, int attachmentType) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        MimeMessage originalMessage = originalMail.getMessage();
        if (attachmentType == 1) {
            part.setContent((Object)this.getMessageHeaders(originalMessage), "text/plain");
            part.setHeader("Content-Type", "text/rfc822-headers");
        } else {
            part.setContent((Object)originalMessage, "message/rfc822");
        }
        if (originalMessage.getSubject() != null && originalMessage.getSubject().trim().length() > 0) {
            part.setFileName(originalMessage.getSubject().trim());
        } else {
            part.setFileName("No Subject");
        }
        part.setDisposition("Attachment");
        return part;
    }

    protected String getStatus(MessagingException me) {
        if (me.getNextException() == null) {
            String mess = me.getMessage();
            Matcher m = statusPattern.matcher(mess);
            StringBuffer sb = new StringBuffer();
            if (m.matches()) {
                sb.append(m.group(1));
                return sb.toString();
            }
            if (mess.startsWith("There are no DNS entries for the hostname")) {
                return DSNStatus.getStatus((int)5, (String)"1.2");
            }
            if (mess.equals("No mail server(s) available at this time.")) {
                return DSNStatus.getStatus((int)4, (String)"4.1");
            }
            return DSNStatus.getStatus((int)5, (String)"0.0");
        }
        Exception ex1 = me.getNextException();
        Matcher m = statusPattern.matcher(ex1.getMessage());
        StringBuffer sb = new StringBuffer();
        if (m.matches()) {
            sb.append(m.group(1));
            return sb.toString();
        }
        if (ex1 instanceof SendFailedException) {
            int smtpCode = 0;
            try {
                smtpCode = Integer.parseInt(ex1.getMessage().substring(0, 3));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            switch (smtpCode) {
                case 450: {
                    return DSNStatus.getStatus((int)4, (String)"2.0");
                }
                case 451: {
                    return DSNStatus.getStatus((int)4, (String)"3.0");
                }
                case 452: {
                    return DSNStatus.getStatus((int)4, (String)"3.1");
                }
                case 500: {
                    return DSNStatus.getStatus((int)5, (String)"5.2");
                }
                case 501: {
                    return DSNStatus.getStatus((int)5, (String)"5.4");
                }
                case 502: {
                    return DSNStatus.getStatus((int)5, (String)"5.1");
                }
                case 503: {
                    return DSNStatus.getStatus((int)5, (String)"5.1");
                }
                case 504: {
                    return DSNStatus.getStatus((int)5, (String)"5.4");
                }
                case 550: {
                    return DSNStatus.getStatus((int)5, (String)"2.0");
                }
                case 551: {
                    return DSNStatus.getStatus((int)5, (String)"7.1");
                }
                case 552: {
                    return DSNStatus.getStatus((int)5, (String)"2.2");
                }
                case 553: {
                    return DSNStatus.getStatus((int)5, (String)"1.3");
                }
                case 554: {
                    return DSNStatus.getStatus((int)5, (String)"0.0");
                }
                case 571: {
                    return DSNStatus.getStatus((int)5, (String)"7.1");
                }
            }
            if (ex1.getMessage().startsWith("4")) {
                return DSNStatus.getStatus((int)4, (String)"5.0");
            }
            return DSNStatus.getStatus((int)5, (String)"5.0");
        }
        if (ex1 instanceof UnknownHostException) {
            return DSNStatus.getStatus((int)5, (String)"1.2");
        }
        if (ex1 instanceof ConnectException) {
            return DSNStatus.getStatus((int)4, (String)"4.2");
        }
        if (ex1 instanceof SocketException) {
            return DSNStatus.getStatus((int)4, (String)"4.2");
        }
        return DSNStatus.getStatus((int)5, (String)"0.0");
    }

    public String getMailetInfo() {
        return "DSNBounce Mailet";
    }

    @Override
    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"debug", "passThrough", "messageString", "attachment", "sender", "prefix"};
        return allowedArray;
    }

    @Override
    protected int getAttachmentType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("attachment", "message"));
    }

    @Override
    protected Collection<MailAddress> getRecipients() {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        newRecipients.add(AbstractRedirect.SpecialAddress.REVERSE_PATH);
        return newRecipients;
    }

    @Override
    protected InternetAddress[] getTo() {
        InternetAddress[] apparentlyTo = new InternetAddress[]{AbstractRedirect.SpecialAddress.REVERSE_PATH.toInternetAddress()};
        return apparentlyTo;
    }

    @Override
    protected MailAddress getReversePath(Mail originalMail) {
        return AbstractRedirect.SpecialAddress.NULL;
    }

    static {
        String status_pattern_string = ".*\\s*([245]\\.\\d{1,3}\\.\\d{1,3}).*\\s*";
        String diag_pattern_string = "^\\d{3}\\s.*$";
        try {
            statusPattern = Pattern.compile(status_pattern_string);
        }
        catch (PatternSyntaxException mpe) {
            System.err.println("Malformed pattern: " + status_pattern_string);
            mpe.printStackTrace(System.err);
        }
        try {
            diagPattern = Pattern.compile(diag_pattern_string);
        }
        catch (PatternSyntaxException mpe) {
            System.err.println("Malformed pattern: " + diag_pattern_string);
        }
    }
}

