/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.MailAddress;

public class Forward
extends AbstractRedirect {
    public String getMailetInfo() {
        return "Forward Mailet";
    }

    @Override
    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"debug", "passThrough", "fakeDomainCheck", "forwardto", "forwardTo"};
        return allowedArray;
    }

    @Override
    protected int getInLineType() throws MessagingException {
        return 0;
    }

    @Override
    protected int getAttachmentType() throws MessagingException {
        return 4;
    }

    @Override
    protected String getMessage() throws MessagingException {
        return "";
    }

    @Override
    protected Collection getRecipients() throws MessagingException {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        String addressList = this.getInitParameter("forwardto", this.getInitParameter("forwardTo"));
        if (addressList == null) {
            throw new MessagingException("Failed to initialize \"recipients\" list: no <forwardTo> or <forwardto> init parameter found");
        }
        try {
            InternetAddress[] iaarray = InternetAddress.parse((String)addressList, (boolean)false);
            for (int i = 0; i < iaarray.length; ++i) {
                String addressString = iaarray[i].getAddress();
                MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "from", "replyTo", "reversePath", "unaltered", "recipients", "to", "null"});
                if (specialAddress != null) {
                    newRecipients.add(specialAddress);
                    continue;
                }
                newRecipients.add(new MailAddress(iaarray[i]));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getRecipients() parsing: " + addressList, e);
        }
        if (newRecipients.size() == 0) {
            throw new MessagingException("Failed to initialize \"recipients\" list; empty <recipients> init parameter found.");
        }
        return newRecipients;
    }

    @Override
    protected InternetAddress[] getTo() throws MessagingException {
        return null;
    }

    @Override
    protected MailAddress getReplyTo() throws MessagingException {
        return null;
    }

    @Override
    protected MailAddress getReversePath() throws MessagingException {
        return null;
    }

    @Override
    protected MailAddress getSender() throws MessagingException {
        return null;
    }

    @Override
    protected String getSubject() throws MessagingException {
        return null;
    }

    @Override
    protected String getSubjectPrefix() throws MessagingException {
        return null;
    }

    @Override
    protected boolean attachError() {
        return false;
    }

    @Override
    protected boolean isReply() throws MessagingException {
        return false;
    }
}

