/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.ParseException;
import javax.sql.DataSource;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class JDBCAlias
extends GenericMailet {
    protected DataSource datasource;
    protected String query = null;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCAlias.this.log("JDBCAlias: " + logString);
        }
    };

    @Resource(name="datasource")
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void init() throws MessagingException {
        String mappingsURL = this.getInitParameter("mappings");
        String datasourceName = mappingsURL.substring(5);
        int pos = datasourceName.indexOf("/");
        String tableName = datasourceName.substring(pos + 1);
        datasourceName = datasourceName.substring(0, pos);
        Connection conn = null;
        if (this.getInitParameter("source_column") == null) {
            throw new MailetException("source_column not specified for JDBCAlias");
        }
        if (this.getInitParameter("target_column") == null) {
            throw new MailetException("target_column not specified for JDBCAlias");
        }
        try {
            conn = this.datasource.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                StringBuffer exceptionBuffer = new StringBuffer(128).append("Could not find table '").append(tableName).append("' in datasource '").append(datasourceName).append("'");
                throw new MailetException(exceptionBuffer.toString());
            }
            StringBuffer queryBuffer = new StringBuffer(128).append("SELECT ").append(this.getInitParameter("target_column")).append(" FROM ").append(tableName).append(" WHERE ").append(this.getInitParameter("source_column")).append(" = ?");
            this.query = queryBuffer.toString();
        }
        catch (MailetException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException("Error initializing JDBCAlias", e);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(Mail mail) throws MessagingException {
        conn = null;
        mappingStmt = null;
        mappingRS = null;
        recipients = mail.getRecipients();
        recipientsToRemove = new Vector<MailAddress>();
        recipientsToAdd = new Vector<MailAddress>();
        try {
            conn = this.datasource.getConnection();
            mappingStmt = conn.prepareStatement(this.query);
            i = recipients.iterator();
            while (i.hasNext()) {
                try {
                    source = (MailAddress)i.next();
                    mappingStmt.setString(1, source.toString());
                    mappingRS = mappingStmt.executeQuery();
                    if (!mappingRS.next()) {
                        localRS = mappingRS;
                        mappingRS = null;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var13_15) {
                    localRS = mappingRS;
                    mappingRS = null;
                    this.theJDBCUtil.closeJDBCResultSet(localRS);
                    throw var13_15;
                }
                this.theJDBCUtil.closeJDBCResultSet(localRS);
                continue;
lbl-1000:
                // 1 sources

                {
                    try {
                        targetString = mappingRS.getString(1);
                        target = new MailAddress(targetString);
                        recipientsToRemove.add(source);
                        recipientsToAdd.add(target);
                    }
                    catch (ParseException pe) {
                        exceptionBuffer = new StringBuffer(128).append("There is an invalid alias from ").append(source).append(" to ").append(mappingRS.getString(1));
                        this.log(exceptionBuffer.toString());
                        localRS = mappingRS;
                        mappingRS = null;
                        this.theJDBCUtil.closeJDBCResultSet(localRS);
                        continue;
                    }
                    localRS = mappingRS;
                    mappingRS = null;
                }
                this.theJDBCUtil.closeJDBCResultSet(localRS);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable var15_17) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw var15_17;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        recipients.removeAll(recipientsToRemove);
        recipients.addAll(recipientsToAdd);
    }

    public String getMailetInfo() {
        return "JDBC aliasing mailet";
    }
}

