/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.sql.DataSource;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;
import org.apache.james.transport.mailets.AbstractRecipientRewriteTable;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetException;

@Deprecated
public class JDBCRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    protected DataSource datasource;
    protected String query = null;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCRecipientRewriteTable.this.log("JDBCRecipientRewriteTable: " + logString);
        }
    };

    @Resource(name="datasource")
    public void setDataSourceSelector(DataSource datasource) {
        this.datasource = datasource;
    }

    public void init() throws MessagingException {
        if (this.getInitParameter("table") == null) {
            throw new MailetException("Table location not specified for JDBCRecipientRewriteTable");
        }
        String tableURL = this.getInitParameter("table");
        String datasourceName = tableURL.substring(5);
        int pos = datasourceName.indexOf("/");
        String tableName = datasourceName.substring(pos + 1);
        datasourceName = datasourceName.substring(0, pos);
        Connection conn = null;
        try {
            conn = this.datasource.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                StringBuffer exceptionBuffer = new StringBuffer(128).append("Could not find table '").append(tableName).append("' in datasource '").append(datasourceName).append("'");
                throw new MailetException(exceptionBuffer.toString());
            }
            this.query = this.getInitParameter("sqlquery", RecipientRewriteTableUtil.QUERY);
        }
        catch (MailetException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException("Error initializing JDBCRecipientRewriteTable", e);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void mapRecipients(Map<MailAddress, String> recipientsMap) throws MessagingException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        Set<MailAddress> recipients = recipientsMap.keySet();
        try {
            conn = this.datasource.getConnection();
            mappingStmt = conn.prepareStatement(this.query);
            Iterator i = recipients.iterator();
            while (i.hasNext()) {
                ResultSet mappingRS = null;
                try {
                    MailAddress source = (MailAddress)i.next();
                    mappingStmt.setString(1, source.getLocalPart());
                    mappingStmt.setString(2, source.getDomain());
                    mappingStmt.setString(3, source.getDomain());
                    mappingRS = mappingStmt.executeQuery();
                    if (mappingRS.next()) {
                        String targetString = mappingRS.getString(1);
                        recipientsMap.put(source, targetString);
                    }
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    public String getMailetInfo() {
        return "JDBC Virtual User Table mailet";
    }
}

