/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.transport.mailets.SieveMailet;
import org.apache.james.transport.mailets.UsersRepositoryAliasingForwarding;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMailet;

public class LocalDelivery
extends GenericMailet {
    private UsersRepositoryAliasingForwarding aliasingMailet;
    private SieveMailet sieveMailet;
    private UsersRepository usersRepository;
    private MailboxManager mailboxManager;

    @Resource(name="usersrepository")
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public void service(Mail mail) throws MessagingException {
        this.aliasingMailet.service(mail);
        if (mail.getState() != "ghost") {
            this.sieveMailet.service(mail);
        }
    }

    public String getMailetInfo() {
        return "Local Delivery Mailet";
    }

    public void init() throws MessagingException {
        super.init();
        this.aliasingMailet = new UsersRepositoryAliasingForwarding();
        this.aliasingMailet.setUsersRepository(this.usersRepository);
        this.aliasingMailet.init(this.getMailetConfig());
        this.sieveMailet = new SieveMailet();
        MailetConfig m = new MailetConfig(){

            public String getInitParameter(String name) {
                if ("addDeliveryHeader".equals(name)) {
                    return "Delivered-To";
                }
                if ("resetReturnPath".equals(name)) {
                    return "true";
                }
                return LocalDelivery.this.getMailetConfig().getInitParameter(name);
            }

            public Iterator getInitParameterNames() {
                IteratorChain c = new IteratorChain();
                ArrayList<String> h = new ArrayList<String>();
                h.add("addDeliveryHeader");
                h.add("resetReturnPath");
                c.addIterator(LocalDelivery.this.getMailetConfig().getInitParameterNames());
                c.addIterator(h.iterator());
                return c;
            }

            public MailetContext getMailetContext() {
                return LocalDelivery.this.getMailetConfig().getMailetContext();
            }

            public String getMailetName() {
                return LocalDelivery.this.getMailetConfig().getMailetName();
            }
        };
        this.sieveMailet.setUsersRepository(this.usersRepository);
        this.sieveMailet.setMailboxManager(this.mailboxManager);
        this.sieveMailet.init(m);
        this.sieveMailet.setQuiet(true);
    }
}

