/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.AbstractNotify;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.MailAddress;

public class NotifySender
extends AbstractNotify {
    public String getMailetInfo() {
        return "NotifySender Mailet";
    }

    @Override
    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"debug", "passThrough", "fakeDomainCheck", "inline", "attachment", "message", "notice", "sender", "sendingAddress", "prefix", "attachError", "attachStackTrace", "to"};
        return allowedArray;
    }

    @Override
    protected Collection<MailAddress> getRecipients() {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        newRecipients.add(AbstractRedirect.SpecialAddress.SENDER);
        return newRecipients;
    }

    @Override
    protected InternetAddress[] getTo() throws MessagingException {
        String addressList = this.getInitParameter("to");
        InternetAddress[] iaarray = new InternetAddress[]{AbstractRedirect.SpecialAddress.SENDER.toInternetAddress()};
        if (addressList != null) {
            MailAddress specialAddress = this.getSpecialAddress(addressList, new String[]{"sender", "unaltered", "from"});
            if (specialAddress != null) {
                iaarray[0] = specialAddress.toInternetAddress();
            } else {
                this.log("\"to\" parameter ignored, set to sender");
            }
        }
        return iaarray;
    }

    @Override
    protected boolean attachError() throws MessagingException {
        String parameter = this.getInitParameter("attachStackTrace");
        if (parameter == null) {
            return super.attachError();
        }
        return Boolean.valueOf(parameter);
    }
}

