/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.transport.mailets.AbstractRecipientRewriteTableMailet;
import org.apache.mailet.MailAddress;

public class RecipientRewriteTable
extends AbstractRecipientRewriteTableMailet {
    private org.apache.james.rrt.api.RecipientRewriteTable vut;

    @Resource(name="recipientrewritetable")
    public final void setRecipientRewriteTable(org.apache.james.rrt.api.RecipientRewriteTable vut) {
        this.vut = vut;
    }

    @Override
    public Collection<MailAddress> processMail(MailAddress sender, MailAddress recipient, MimeMessage message) throws MessagingException {
        try {
            Collection mappings = this.vut.getMappings(recipient.getLocalPart(), recipient.getDomain());
            if (mappings != null) {
                return this.handleMappings(mappings, sender, recipient, message);
            }
        }
        catch (RecipientRewriteTable.ErrorMappingException e) {
            StringBuilder errorBuffer = new StringBuilder(128).append("A problem as occoured trying to alias and forward user ").append(recipient).append(": ").append(e.getMessage());
            throw new MessagingException(errorBuffer.toString());
        }
        catch (RecipientRewriteTableException e) {
            throw new MessagingException("Unable to access RecipientRewriteTable", (Exception)((Object)e));
        }
        ArrayList<MailAddress> rcpts = new ArrayList<MailAddress>();
        rcpts.add(recipient);
        return rcpts;
    }

    public String getMailetInfo() {
        return "RecipientRewriteTable Mailet";
    }
}

