/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.util.Collection;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.AbstractRedirect;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class Redirect
extends AbstractRedirect {
    public String getMailetInfo() {
        return "Redirect Mailet";
    }

    @Override
    protected String[] getAllowedInitParameters() {
        String[] allowedArray = new String[]{"static", "debug", "passThrough", "fakeDomainCheck", "inline", "attachment", "message", "recipients", "to", "replyTo", "replyto", "reversePath", "sender", "subject", "prefix", "attachError", "isReply"};
        return allowedArray;
    }

    @Override
    protected boolean isStatic() {
        return this.isStatic;
    }

    @Override
    protected int getInLineType() throws MessagingException {
        return this.getTypeCode(this.getInitParameter("inline", "body"));
    }

    @Override
    protected Collection<MailAddress> getRecipients() throws MessagingException {
        HashSet<MailAddress> newRecipients = new HashSet<MailAddress>();
        String addressList = this.getInitParameter("recipients", this.getInitParameter("to"));
        if (addressList == null) {
            return null;
        }
        try {
            InternetAddress[] iaarray = InternetAddress.parse((String)addressList, (boolean)false);
            for (int i = 0; i < iaarray.length; ++i) {
                String addressString = iaarray[i].getAddress();
                MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "from", "replyTo", "reversePath", "unaltered", "recipients", "to", "null"});
                if (specialAddress != null) {
                    newRecipients.add(specialAddress);
                    continue;
                }
                newRecipients.add(new MailAddress(iaarray[i]));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getRecipients() parsing: " + addressList, e);
        }
        if (newRecipients.size() == 0) {
            throw new MessagingException("Failed to initialize \"recipients\" list; empty <recipients> init parameter found.");
        }
        return newRecipients;
    }

    @Override
    protected InternetAddress[] getTo() throws MessagingException {
        InternetAddress[] iaarray = null;
        String addressList = this.getInitParameter("to", this.getInitParameter("recipients"));
        if (addressList == null) {
            return null;
        }
        try {
            iaarray = InternetAddress.parse((String)addressList, (boolean)false);
            for (int i = 0; i < iaarray.length; ++i) {
                String addressString = iaarray[i].getAddress();
                MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "from", "replyTo", "reversePath", "unaltered", "recipients", "to", "null"});
                if (specialAddress == null) continue;
                iaarray[i] = specialAddress.toInternetAddress();
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getTo() parsing: " + addressList, e);
        }
        if (iaarray.length == 0) {
            throw new MessagingException("Failed to initialize \"to\" list; empty <to> init parameter found.");
        }
        return iaarray;
    }

    @Override
    protected MailAddress getReversePath() throws MessagingException {
        String addressString = this.getInitParameter("reversePath");
        if (addressString != null) {
            MailAddress specialAddress = this.getSpecialAddress(addressString, new String[]{"postmaster", "sender", "null"});
            if (specialAddress != null) {
                return specialAddress;
            }
            try {
                return new MailAddress(addressString);
            }
            catch (Exception e) {
                throw new MessagingException("Exception thrown in getReversePath() parsing: " + addressString, e);
            }
        }
        return null;
    }

    @Override
    protected MailAddress getReversePath(Mail originalMail) throws MessagingException {
        MailAddress reversePath = super.getReversePath(originalMail);
        if (reversePath == null) {
            reversePath = this.getSender(originalMail);
        }
        return reversePath;
    }
}

