/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.transport.mailets.RemoteDeliverySocketFactory;
import org.apache.james.transport.util.MailetContextLog;
import org.apache.james.util.TimeConverter;
import org.apache.mailet.HostAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;

public class RemoteDelivery
extends GenericMailet
implements Runnable {
    private static final long DEFAULT_DELAY_TIME = 21600000L;
    private static final String PATTERN_STRING = "\\s*([0-9]*\\s*[\\*])?\\s*([0-9]+)\\s*([a-z,A-Z]*)\\s*";
    private static Pattern PATTERN = null;
    private DNSService dnsServer;
    private boolean isDebug = false;
    private long[] delayTimes;
    private int maxRetries = 5;
    private long smtpTimeout = 180000L;
    private boolean sendPartial = false;
    private int connectionTimeout = 60000;
    private int workersThreadCount = 1;
    private Collection<String> gatewayServer = null;
    private String authUser = null;
    private String authPass = null;
    private String bindAddress = null;
    private boolean isBindUsed = false;
    private Collection<Thread> workersThreads = new Vector<Thread>();
    private volatile boolean destroyed = false;
    private String bounceProcessor = null;
    private Properties defprops = new Properties();
    private int dnsProblemRetry = 0;
    private MailQueueFactory queueFactory;
    private MailQueue queue;
    private String heloName;
    private MailetContextLog logAdapter;
    private DomainList domainList;
    private boolean startTLS = false;

    @Resource(name="mailqueuefactory")
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dnsService) {
        this.dnsServer = dnsService;
    }

    @Resource(name="domainlist")
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void init() throws MessagingException {
        this.isDebug = this.getInitParameter("debug") == null ? false : Boolean.valueOf(this.getInitParameter("debug"));
        this.logAdapter = new MailetContextLog(this.getMailetContext(), this.isDebug);
        ArrayList<Delay> delayTimesList = new ArrayList<Delay>();
        try {
            if (this.getInitParameter("delayTime") != null) {
                String delayTimesParm = this.getInitParameter("delayTime");
                StringTokenizer st = new StringTokenizer(delayTimesParm, ",");
                while (st.hasMoreTokens()) {
                    String delayTime = st.nextToken();
                    delayTimesList.add(new Delay(delayTime));
                }
            } else {
                delayTimesList.add(new Delay());
            }
        }
        catch (Exception e) {
            this.log("Invalid delayTime setting: " + this.getInitParameter("delayTime"));
        }
        try {
            int totalAttempts;
            if (this.getInitParameter("maxRetries") != null) {
                this.maxRetries = Integer.parseInt(this.getInitParameter("maxRetries"));
            }
            if ((totalAttempts = this.calcTotalAttempts(delayTimesList)) > this.maxRetries) {
                this.log("Total number of delayTime attempts exceeds maxRetries specified.  Increasing maxRetries from " + this.maxRetries + " to " + totalAttempts);
                this.maxRetries = totalAttempts;
            } else {
                int extra = this.maxRetries - totalAttempts;
                if (extra != 0) {
                    this.log("maxRetries is larger than total number of attempts specified.  Increasing last delayTime with " + extra + " attempts ");
                    if (delayTimesList.size() != 0) {
                        Delay delay = delayTimesList.get(delayTimesList.size() - 1);
                        delay.setAttempts(delay.getAttempts() + extra);
                        this.log("Delay of " + delay.getDelayTime() + " msecs is now attempted: " + delay.getAttempts() + " times");
                    } else {
                        throw new MessagingException("No delaytimes, cannot continue");
                    }
                }
            }
            this.delayTimes = this.expandDelays(delayTimesList);
        }
        catch (Exception e) {
            this.log("Invalid maxRetries setting: " + this.getInitParameter("maxRetries"));
        }
        String outgoing = this.getInitParameter("outgoing");
        if (outgoing == null) {
            outgoing = "outgoing";
        }
        this.queue = this.queueFactory.getQueue(outgoing);
        try {
            if (this.getInitParameter("timeout") != null) {
                this.smtpTimeout = Integer.parseInt(this.getInitParameter("timeout"));
            }
        }
        catch (Exception e) {
            this.log("Invalid timeout setting: " + this.getInitParameter("timeout"));
        }
        try {
            if (this.getInitParameter("connectiontimeout") != null) {
                this.connectionTimeout = Integer.parseInt(this.getInitParameter("connectiontimeout"));
            }
        }
        catch (Exception e) {
            this.log("Invalid timeout setting: " + this.getInitParameter("timeout"));
        }
        this.sendPartial = this.getInitParameter("sendpartial") == null ? false : Boolean.valueOf(this.getInitParameter("sendpartial"));
        this.bounceProcessor = this.getInitParameter("bounceProcessor");
        String sTLS = this.getInitParameter("startTLS");
        if (sTLS != null) {
            this.startTLS = Boolean.valueOf(sTLS);
        }
        String gateway = this.getInitParameter("gateway");
        String gatewayPort = this.getInitParameter("gatewayPort");
        if (gateway != null) {
            this.gatewayServer = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(gateway, ",");
            while (st.hasMoreTokens()) {
                String server = st.nextToken().trim();
                if (server.indexOf(58) < 0 && gatewayPort != null) {
                    server = server + ":";
                    server = server + gatewayPort;
                }
                if (this.isDebug) {
                    this.log("Adding SMTP gateway: " + server);
                }
                this.gatewayServer.add(server);
            }
            this.authUser = this.getInitParameter("gatewayUsername");
            if (this.authUser == null) {
                this.authUser = this.getInitParameter("gatewayusername");
            }
            this.authPass = this.getInitParameter("gatewayPassword");
        }
        this.bindAddress = this.getInitParameter("bind");
        this.isBindUsed = this.bindAddress != null;
        try {
            if (this.isBindUsed) {
                RemoteDeliverySocketFactory.setBindAdress(this.bindAddress);
            }
        }
        catch (UnknownHostException e) {
            this.log("Invalid bind setting (" + this.bindAddress + "): " + e.toString());
        }
        Iterator i = this.getInitParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith("mail.")) continue;
            this.defprops.put(name, this.getInitParameter(name));
        }
        String dnsRetry = this.getInitParameter("maxDnsProblemRetries");
        if (dnsRetry != null && !dnsRetry.equals("")) {
            this.dnsProblemRetry = Integer.parseInt(dnsRetry);
        }
        this.heloName = this.getInitParameter("heloName");
        this.workersThreadCount = Integer.parseInt(this.getInitParameter("deliveryThreads"));
        this.initDeliveryThreads();
    }

    private void initDeliveryThreads() {
        for (int a = 0; a < this.workersThreadCount; ++a) {
            String threadName = "Remote delivery thread (" + a + ")";
            Thread t = new Thread((Runnable)this, threadName);
            t.start();
            this.workersThreads.add(t);
        }
    }

    private int calcTotalAttempts(ArrayList<Delay> delayList) {
        int sum = 0;
        for (Delay delay : delayList) {
            sum += delay.getAttempts();
        }
        return sum;
    }

    private long[] expandDelays(ArrayList<Delay> list) {
        long[] delays = new long[this.calcTotalAttempts(list)];
        Iterator<Delay> i = list.iterator();
        int idx = 0;
        while (i.hasNext()) {
            Delay delay = i.next();
            for (int j = 0; j < delay.getAttempts(); ++j) {
                delays[idx++] = delay.getDelayTime();
            }
        }
        return delays;
    }

    private long getNextDelay(int retry_count) {
        if (retry_count > this.delayTimes.length) {
            return 21600000L;
        }
        return this.delayTimes[retry_count - 1];
    }

    public String getMailetInfo() {
        return "RemoteDelivery Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        if (this.isDebug) {
            this.log("Remotely delivering mail " + mail.getName());
        }
        Collection recipients = mail.getRecipients();
        if (this.gatewayServer == null) {
            Hashtable<String, ArrayList<MailAddress>> targets = new Hashtable<String, ArrayList<MailAddress>>();
            for (MailAddress target : recipients) {
                String targetServer = target.getDomain().toLowerCase(Locale.US);
                ArrayList<MailAddress> temp = (ArrayList<MailAddress>)targets.get(targetServer);
                if (temp == null) {
                    temp = new ArrayList<MailAddress>();
                    targets.put(targetServer, temp);
                }
                temp.add(target);
            }
            String name = mail.getName();
            for (Map.Entry entry : targets.entrySet()) {
                if (this.isDebug) {
                    StringBuilder logMessageBuffer = new StringBuilder(128).append("Sending mail to ").append(entry.getValue()).append(" on host ").append((String)entry.getKey());
                    this.log(logMessageBuffer.toString());
                }
                mail.setRecipients((Collection)entry.getValue());
                StringBuilder nameBuffer = new StringBuilder(128).append(name).append("-to-").append((String)entry.getKey());
                mail.setName(nameBuffer.toString());
                try {
                    this.queue.enQueue(mail);
                }
                catch (MailQueue.MailQueueException e) {
                    this.log("Unable to queue mail " + mail.getName() + " for recipients + " + mail.getRecipients().toString(), e);
                }
            }
        } else {
            if (this.isDebug) {
                StringBuilder logMessageBuffer = new StringBuilder(128).append("Sending mail to ").append(mail.getRecipients()).append(" via ").append(this.gatewayServer);
                this.log(logMessageBuffer.toString());
            }
            try {
                this.queue.enQueue(mail);
            }
            catch (MailQueue.MailQueueException e) {
                this.log("Unable to queue mail " + mail.getName() + " for recipients + " + mail.getRecipients().toString(), e);
            }
        }
        mail.setState("ghost");
    }

    public synchronized void destroy() {
        this.destroyed = true;
        for (Thread t : this.workersThreads) {
            t.interrupt();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Properties props = new Properties();
        props.put("mail.debug", "false");
        props.put("mail.smtp.ehlo", "true");
        props.setProperty("mail.smtp.allow8bitmime", "true");
        props.put("mail.smtp.timeout", this.smtpTimeout + "");
        props.put("mail.smtp.connectiontimeout", this.connectionTimeout + "");
        props.put("mail.smtp.sendpartial", String.valueOf(this.sendPartial));
        props.put("mail.smtp.localhost", this.getHeloName());
        props.put("mail.smtp.starttls.enable", String.valueOf(this.startTLS));
        if (this.isBindUsed) {
            props.put("mail.smtp.socketFactory.class", RemoteDeliverySocketFactory.class.getClass());
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.authUser != null) {
            props.put("mail.smtp.auth", "true");
        }
        props.putAll((Map<?, ?>)this.defprops);
        Session session = this.obtainSession(props);
        try {
            while (!Thread.interrupted() && !this.destroyed) {
                try {
                    MailQueue.MailQueueItem queueItem = this.queue.deQueue();
                    Mail mail = queueItem.getMail();
                    String key = mail.getName();
                    try {
                        if (this.isDebug) {
                            String message = Thread.currentThread().getName() + " will process mail " + key;
                            this.log(message);
                        }
                        if (this.deliver(mail, session)) {
                            LifecycleUtil.dispose((Object)mail);
                        } else {
                            int retries = 0;
                            try {
                                retries = Integer.parseInt(mail.getErrorMessage());
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            long delay = this.getNextDelay(retries);
                            this.queue.enQueue(mail, delay, TimeUnit.MILLISECONDS);
                            LifecycleUtil.dispose((Object)mail);
                        }
                        mail = null;
                        queueItem.done(true);
                    }
                    catch (Exception e) {
                        LifecycleUtil.dispose((Object)mail);
                        queueItem.done(false);
                        throw new MailQueue.MailQueueException("Unable to perform dequeue", e);
                    }
                }
                catch (Throwable e) {
                    if (this.destroyed) continue;
                    this.log("Exception caught in RemoteDelivery.run()", e);
                }
            }
        }
        finally {
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(Mail mail, Session session) {
        try {
            if (this.isDebug) {
                this.log("Attempting to deliver " + mail.getName());
            }
            MimeMessage message = mail.getMessage();
            Collection recipients = mail.getRecipients();
            InternetAddress[] addr = new InternetAddress[recipients.size()];
            int j = 0;
            for (MailAddress rcpt : recipients) {
                addr[j] = rcpt.toInternetAddress();
                ++j;
            }
            if (addr.length <= 0) {
                this.log("No recipients specified... not sure how this could have happened.");
                return true;
            }
            MXHostAddressIterator targetServers = null;
            if (this.gatewayServer == null) {
                MailAddress rcpt;
                rcpt = (MailAddress)recipients.iterator().next();
                String host = rcpt.getDomain();
                try {
                    targetServers = new MXHostAddressIterator(this.dnsServer.findMXRecords(host).iterator(), this.dnsServer, false, (Logger)this.logAdapter);
                }
                catch (TemporaryResolutionException e) {
                    this.log("Temporary problem looking up mail server for host: " + host);
                    StringBuilder exceptionBuffer = new StringBuilder(128).append("Temporary problem looking up mail server for host: ").append(host).append(".  I cannot determine where to send this message.");
                    return this.failMessage(mail, (Exception)((Object)new MessagingException(exceptionBuffer.toString())), false);
                }
                if (!targetServers.hasNext()) {
                    this.log("No mail server found for: " + host);
                    StringBuilder exceptionBuffer = new StringBuilder(128).append("There are no DNS entries for the hostname ").append(host).append(".  I cannot determine where to send this message.");
                    int retry = 0;
                    try {
                        retry = Integer.parseInt(mail.getErrorMessage());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (retry == 0 || retry > this.dnsProblemRetry) {
                        return this.failMessage(mail, (Exception)((Object)new MessagingException(exceptionBuffer.toString())), true);
                    }
                    return this.failMessage(mail, (Exception)((Object)new MessagingException(exceptionBuffer.toString())), false);
                }
            } else {
                targetServers = this.getGatewaySMTPHostAddresses(this.gatewayServer);
            }
            Throwable lastError = null;
            while (targetServers.hasNext()) {
                StringBuilder logMessageBuffer;
                try {
                    Properties props = session.getProperties();
                    if (mail.getSender() == null) {
                        props.put("mail.smtp.from", "<>");
                    } else {
                        String sender = mail.getSender().toString();
                        props.put("mail.smtp.from", sender);
                    }
                    HostAddress outgoingMailServer = (HostAddress)targetServers.next();
                    logMessageBuffer = new StringBuilder(256).append("Attempting delivery of ").append(mail.getName()).append(" to host ").append(outgoingMailServer.getHostName()).append(" at ").append(outgoingMailServer.getHost()).append(" from ").append(props.get("mail.smtp.from")).append(" for addresses ").append(Arrays.asList(addr));
                    this.log(logMessageBuffer.toString());
                    Transport transport = null;
                    transport = session.getTransport((URLName)outgoingMailServer);
                    try {
                        if (this.authUser != null) {
                            transport.connect(outgoingMailServer.getHostName(), this.authUser, this.authPass);
                        } else {
                            transport.connect();
                        }
                    }
                    catch (MessagingException me) {
                        if (this.isDebug) {
                            this.log(me.getMessage(), me.getCause());
                        } else {
                            this.log(me.getMessage());
                        }
                        if (transport == null) continue;
                        try {
                            transport.close();
                        }
                        catch (MessagingException e) {
                            this.log("Warning: could not close the SMTP transport after sending mail (" + mail.getName() + ") to " + outgoingMailServer.getHostName() + " at " + outgoingMailServer.getHost() + " for " + mail.getRecipients() + "; probably the server has already closed the " + "connection. Message is considered to be delivered. Exception: " + e.getMessage());
                        }
                        transport = null;
                        continue;
                    }
                    try {
                        if (transport.getClass().getName().endsWith(".SMTPTransport")) {
                            boolean supports8bitmime = false;
                            try {
                                Method supportsExtension = transport.getClass().getMethod("supportsExtension", String.class);
                                supports8bitmime = (Boolean)supportsExtension.invoke((Object)transport, "8BITMIME");
                            }
                            catch (NoSuchMethodException nsme) {
                            }
                            catch (IllegalAccessException iae) {
                            }
                            catch (IllegalArgumentException iae) {
                            }
                            catch (InvocationTargetException ite) {
                                // empty catch block
                            }
                            if (!supports8bitmime) {
                                try {
                                    this.convertTo7Bit((MimePart)message);
                                }
                                catch (IOException e) {
                                    this.log("Error during the conversion to 7 bit.", e);
                                }
                            }
                        } else {
                            try {
                                this.convertTo7Bit((MimePart)message);
                            }
                            catch (IOException e) {
                                this.log("Error during the conversion to 7 bit.", e);
                            }
                        }
                        transport.sendMessage((Message)message, (Address[])addr);
                    }
                    finally {
                        if (transport != null) {
                            try {
                                transport.close();
                            }
                            catch (MessagingException e) {
                                this.log("Warning: could not close the SMTP transport after sending mail (" + mail.getName() + ") to " + outgoingMailServer.getHostName() + " at " + outgoingMailServer.getHost() + " for " + mail.getRecipients() + "; probably the server has already closed the " + "connection. Message is considered to be delivered. Exception: " + e.getMessage());
                            }
                            transport = null;
                        }
                    }
                    logMessageBuffer = new StringBuilder(256).append("Mail (").append(mail.getName()).append(") sent successfully to ").append(outgoingMailServer.getHostName()).append(" at ").append(outgoingMailServer.getHost()).append(" from ").append(props.get("mail.smtp.from")).append(" for ").append(mail.getRecipients());
                    this.log(logMessageBuffer.toString());
                    return true;
                }
                catch (SendFailedException sfe) {
                    Address[] validSent;
                    this.logSendFailedException(sfe);
                    if (sfe.getValidSentAddresses() != null && (validSent = sfe.getValidSentAddresses()).length > 0) {
                        logMessageBuffer = new StringBuilder(256).append("Mail (").append(mail.getName()).append(") sent successfully for ").append(Arrays.asList(validSent));
                        this.log(logMessageBuffer.toString());
                    }
                    if (((Object)((Object)sfe)).getClass().getName().endsWith(".SMTPSendFailedException")) {
                        try {
                            int returnCode = (Integer)this.invokeGetter((Object)sfe, "getReturnCode");
                            if (returnCode >= 500 && returnCode <= 599) {
                                throw sfe;
                            }
                        }
                        catch (ClassCastException cce) {
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                    }
                    if (sfe.getValidUnsentAddresses() != null && sfe.getValidUnsentAddresses().length > 0) {
                        if (this.isDebug) {
                            this.log("Send failed, " + sfe.getValidUnsentAddresses().length + " valid addresses remain, continuing with any other servers");
                        }
                        lastError = sfe;
                        continue;
                    }
                    throw sfe;
                }
                catch (MessagingException me) {
                    StringBuilder exceptionBuffer = new StringBuilder(256).append("Exception delivering message (").append(mail.getName()).append(") - ").append(me.getMessage());
                    this.log(exceptionBuffer.toString());
                    if (me.getNextException() != null && me.getNextException() instanceof IOException) {
                        lastError = me;
                        continue;
                    }
                    throw me;
                }
            }
            if (lastError != null) {
                throw lastError;
            }
        }
        catch (SendFailedException sfe) {
            Address[] address;
            this.logSendFailedException(sfe);
            Collection recipients = mail.getRecipients();
            boolean deleteMessage = false;
            try {
                if (((Object)((Object)sfe)).getClass().getName().endsWith(".SMTPSendFailedException")) {
                    int returnCode = (Integer)this.invokeGetter((Object)sfe, "getReturnCode");
                    deleteMessage = returnCode >= 500 && returnCode <= 599;
                } else {
                    Exception ne;
                    Throwable me = sfe;
                    while ((ne = me.getNextException()) != null && ne instanceof MessagingException) {
                        me = (MessagingException)((Object)ne);
                        if (!me.getClass().getName().endsWith(".SMTPAddressFailedException")) continue;
                        int returnCode = (Integer)this.invokeGetter(me, "getReturnCode");
                        deleteMessage = returnCode >= 500 && returnCode <= 599;
                    }
                }
            }
            catch (IllegalStateException ise) {
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            if (this.isDebug) {
                this.log("Recipients: " + recipients);
            }
            if (sfe.getInvalidAddresses() != null && (address = sfe.getInvalidAddresses()).length > 0) {
                recipients.clear();
                for (int i = 0; i < address.length; ++i) {
                    try {
                        recipients.add(new MailAddress(address[i].toString()));
                        continue;
                    }
                    catch (ParseException pe) {
                        this.log("Can't parse invalid address: " + pe.getMessage());
                    }
                }
                if (this.isDebug) {
                    this.log("Invalid recipients: " + recipients);
                }
                deleteMessage = this.failMessage(mail, (Exception)((Object)sfe), true);
            }
            if (sfe.getValidUnsentAddresses() != null && (address = sfe.getValidUnsentAddresses()).length > 0) {
                int returnCode;
                recipients.clear();
                for (int i = 0; i < address.length; ++i) {
                    try {
                        recipients.add(new MailAddress(address[i].toString()));
                        continue;
                    }
                    catch (ParseException pe) {
                        this.log("Can't parse unsent address: " + pe.getMessage());
                    }
                }
                if (this.isDebug) {
                    this.log("Unsent recipients: " + recipients);
                }
                deleteMessage = ((Object)((Object)sfe)).getClass().getName().endsWith(".SMTPSendFailedException") ? this.failMessage(mail, (Exception)((Object)sfe), (returnCode = ((Integer)this.invokeGetter((Object)sfe, "getReturnCode")).intValue()) >= 500 && returnCode <= 599) : this.failMessage(mail, (Exception)((Object)sfe), false);
            }
            return deleteMessage;
        }
        catch (MessagingException ex) {
            return this.failMessage(mail, (Exception)((Object)ex), '5' == ex.getMessage().charAt(0));
        }
        catch (Exception ex) {
            return this.failMessage(mail, ex, true);
        }
        return this.failMessage(mail, (Exception)((Object)new MessagingException("No mail server(s) available at this time.")), false);
    }

    private String exceptionToLogString(Exception e) {
        if (e.getClass().getName().endsWith(".SMTPSendFailedException")) {
            return "RemoteHost said: " + e.getMessage();
        }
        if (e instanceof SendFailedException) {
            SendFailedException exception = (SendFailedException)((Object)e);
            if (exception.getInvalidAddresses().length == 0 && exception.getValidUnsentAddresses().length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean smtpExFound = false;
            sb.append("RemoteHost said:");
            if (e instanceof MessagingException) {
                Exception ex;
                while ((ex = ((MessagingException)((Object)e)).getNextException()) != null && ex instanceof MessagingException) {
                    e = ex;
                    if (!ex.getClass().getName().endsWith(".SMTPAddressFailedException")) continue;
                    try {
                        InternetAddress ia = (InternetAddress)this.invokeGetter(ex, "getAddress");
                        sb.append(" ( " + ia + " - [" + ex.getMessage().replaceAll("\\n", "") + "] )");
                        smtpExFound = true;
                    }
                    catch (IllegalStateException ise) {
                    }
                    catch (ClassCastException cce) {}
                }
            }
            if (!smtpExFound) {
                boolean invalidAddr = false;
                sb.append(" ( ");
                if (exception.getInvalidAddresses().length > 0) {
                    sb.append(exception.getInvalidAddresses());
                    invalidAddr = true;
                }
                if (exception.getValidUnsentAddresses().length > 0) {
                    if (invalidAddr) {
                        sb.append(" ");
                    }
                    sb.append(exception.getValidUnsentAddresses());
                }
                sb.append(" - [");
                sb.append(exception.getMessage().replaceAll("\\n", ""));
                sb.append("] )");
            }
            return sb.toString();
        }
        return null;
    }

    private Object invokeGetter(Object target, String getter) {
        try {
            Method getAddress = target.getClass().getMethod(getter, null);
            return getAddress.invoke(target, null);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new IllegalStateException("Exception invoking " + getter + " on a " + target.getClass() + " object");
    }

    private void logSendFailedException(SendFailedException sfe) {
        if (this.isDebug) {
            Exception ne;
            Throwable me = sfe;
            if (me.getClass().getName().endsWith(".SMTPSendFailedException")) {
                try {
                    String command = (String)this.invokeGetter((Object)sfe, "getCommand");
                    Integer returnCode = (Integer)this.invokeGetter((Object)sfe, "getReturnCode");
                    this.log("SMTP SEND FAILED:");
                    this.log(sfe.toString());
                    this.log("  Command: " + command);
                    this.log("  RetCode: " + returnCode);
                    this.log("  Response: " + sfe.getMessage());
                }
                catch (IllegalStateException ise) {
                    this.log("Send failed: " + me.toString());
                }
                catch (ClassCastException cce) {
                    this.log("Send failed: " + me.toString());
                }
            } else {
                this.log("Send failed: " + me.toString());
            }
            while ((ne = me.getNextException()) != null && ne instanceof MessagingException) {
                me = (MessagingException)((Object)ne);
                if (!me.getClass().getName().endsWith(".SMTPAddressFailedException") && !me.getClass().getName().endsWith(".SMTPAddressSucceededException")) continue;
                try {
                    String action = me.getClass().getName().endsWith(".SMTPAddressFailedException") ? "FAILED" : "SUCCEEDED";
                    InternetAddress address = (InternetAddress)this.invokeGetter(me, "getAddress");
                    String command = (String)this.invokeGetter(me, "getCommand");
                    Integer returnCode = (Integer)this.invokeGetter(me, "getReturnCode");
                    this.log("ADDRESS " + action + ":");
                    this.log(me.toString());
                    this.log("  Address: " + address);
                    this.log("  Command: " + command);
                    this.log("  RetCode: " + returnCode);
                    this.log("  Response: " + me.getMessage());
                }
                catch (IllegalStateException ise) {
                }
                catch (ClassCastException cce) {}
            }
        }
    }

    private void convertTo7Bit(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            MimeMultipart parts = (MimeMultipart)part.getContent();
            int count = parts.getCount();
            for (int i = 0; i < count; ++i) {
                this.convertTo7Bit((MimePart)parts.getBodyPart(i));
            }
        } else if ("8bit".equals(part.getEncoding())) {
            String contentTransferEncoding = part.isMimeType("text/*") ? "quoted-printable" : "base64";
            part.setContent(part.getContent(), part.getContentType());
            part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            part.addHeader("X-MIME-Autoconverted", "from 8bit to " + contentTransferEncoding + " by " + this.getMailetContext().getServerInfo());
        }
    }

    private boolean failMessage(Mail mail, Exception ex, boolean permanent) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        if (permanent) {
            out.print("Permanent");
        } else {
            out.print("Temporary");
        }
        String exceptionLog = this.exceptionToLogString(ex);
        StringBuilder logBuffer = new StringBuilder(64).append(" exception delivering mail (").append(mail.getName());
        if (exceptionLog != null) {
            logBuffer.append(". ");
            logBuffer.append(exceptionLog);
        }
        logBuffer.append(": ");
        out.print(logBuffer.toString());
        if (this.isDebug) {
            ex.printStackTrace(out);
        }
        this.log(sout.toString());
        if (!permanent) {
            if (!mail.getState().equals("error")) {
                mail.setState("error");
                mail.setErrorMessage("0");
                mail.setLastUpdated(new Date());
            }
            int retries = 0;
            try {
                retries = Integer.parseInt(mail.getErrorMessage());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (retries < this.maxRetries) {
                logBuffer = new StringBuilder(128).append("Storing message ").append(mail.getName()).append(" into outgoing after ").append(retries).append(" retries");
                this.log(logBuffer.toString());
                mail.setErrorMessage(++retries + "");
                mail.setLastUpdated(new Date());
                return false;
            }
            logBuffer = new StringBuilder(128).append("Bouncing message ").append(mail.getName()).append(" after ").append(retries).append(" retries");
            this.log(logBuffer.toString());
        }
        if (mail.getSender() == null) {
            this.log("Null Sender: no bounce will be generated for " + mail.getName());
            return true;
        }
        if (this.bounceProcessor != null) {
            String cause = ex instanceof MessagingException ? this.getErrorMsg((MessagingException)((Object)ex)) : ex.getMessage();
            mail.setAttribute("delivery-error", (Serializable)((Object)cause));
            mail.setState(this.bounceProcessor);
            MailetContext mc = this.getMailetContext();
            try {
                mc.sendMail(mail);
            }
            catch (MessagingException e) {
                this.log("Exception re-inserting failed mail: ", e);
            }
        } else {
            this.bounce(mail, ex);
        }
        return true;
    }

    protected String getErrorMsg(MessagingException me) {
        if (me.getNextException() == null) {
            return me.getMessage().trim();
        }
        Exception ex1 = me.getNextException();
        return ex1.getMessage().trim();
    }

    private void bounce(Mail mail, Exception ex) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        String machine = "[unknown]";
        try {
            machine = this.getHeloName();
        }
        catch (Exception e) {
            machine = "[address unknown]";
        }
        StringBuilder bounceBuffer = new StringBuilder(128).append("Hi. This is the James mail server at ").append(machine).append(".");
        out.println(bounceBuffer.toString());
        out.println("I'm afraid I wasn't able to deliver your message to the following addresses.");
        out.println("This is a permanent error; I've given up. Sorry it didn't work out.  Below");
        out.println("I include the list of recipients and the reason why I was unable to deliver");
        out.println("your message.");
        out.println();
        Iterator i = mail.getRecipients().iterator();
        while (i.hasNext()) {
            out.println(i.next());
        }
        if (ex instanceof MessagingException) {
            if (((MessagingException)((Object)ex)).getNextException() == null) {
                out.println(ex.getMessage().trim());
            } else {
                Exception ex1 = ((MessagingException)((Object)ex)).getNextException();
                if (ex1 instanceof SendFailedException) {
                    out.println("Remote mail server told me: " + ex1.getMessage().trim());
                } else if (ex1 instanceof UnknownHostException) {
                    out.println("Unknown host: " + ex1.getMessage().trim());
                    out.println("This could be a DNS server error, a typo, or a problem with the recipient's mail server.");
                } else if (ex1 instanceof ConnectException) {
                    out.println(ex1.getMessage().trim());
                } else if (ex1 instanceof SocketException) {
                    out.println("Socket exception: " + ex1.getMessage().trim());
                } else {
                    out.println(ex1.getMessage().trim());
                }
            }
        }
        out.println();
        this.log("Sending failure message " + mail.getName());
        try {
            this.getMailetContext().bounce(mail, sout.toString());
        }
        catch (MessagingException me) {
            this.log("Encountered unexpected messaging exception while bouncing message: " + me.getMessage());
        }
        catch (Exception e) {
            this.log("Encountered unexpected exception while bouncing message: " + e.getMessage());
        }
    }

    protected Session obtainSession(Properties props) {
        return Session.getInstance((Properties)props);
    }

    private Iterator<HostAddress> getGatewaySMTPHostAddresses(Collection<String> gatewayServers) {
        Iterator<String> gateways = gatewayServers.iterator();
        return new MXHostAddressIterator(gateways, this.dnsServer, false, (Logger)this.logAdapter);
    }

    protected String getHeloName() {
        if (this.heloName == null) {
            try {
                return this.domainList.getDefaultDomain();
            }
            catch (DomainListException e) {
                this.log("Unable to access DomainList", e);
                return "localhost";
            }
        }
        return this.heloName;
    }

    static {
        try {
            PATTERN = Pattern.compile(PATTERN_STRING);
        }
        catch (PatternSyntaxException mpe) {
            mpe.printStackTrace(System.err);
        }
    }

    private static final class Delay {
        private int attempts = 1;
        private long delayTime = 21600000L;

        public Delay(String initString) throws MessagingException {
            String unit = "msec";
            Matcher res = PATTERN.matcher(initString);
            if (res.matches()) {
                if (res.group(1) != null && !res.group(1).equals("")) {
                    String attemptMatch = res.group(1);
                    attemptMatch = attemptMatch.substring(0, attemptMatch.length() - 1).trim();
                    this.attempts = Integer.parseInt(attemptMatch);
                }
                this.delayTime = Long.parseLong(res.group(2));
                if (!res.group(3).equals("")) {
                    unit = res.group(3).toLowerCase(Locale.US);
                }
            } else {
                throw new MessagingException(initString + " does not match " + RemoteDelivery.PATTERN_STRING);
            }
            try {
                this.delayTime = TimeConverter.getMilliSeconds((long)this.delayTime, (String)unit);
            }
            catch (NumberFormatException e) {
                throw new MessagingException(e.getMessage());
            }
        }

        public Delay() {
        }

        public long getDelayTime() {
            return this.delayTime;
        }

        public int getAttempts() {
            return this.attempts;
        }

        public void setAttempts(int value) {
            this.attempts = value;
        }

        public String toString() {
            String message = this.getAttempts() + "*" + this.getDelayTime() + "msecs";
            return message;
        }
    }
}

