/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Serializable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public class SPF
extends GenericMailet {
    private boolean addHeader = false;
    private org.apache.james.jspf.impl.SPF spf;
    public static final String EXPLANATION_ATTRIBUTE = "org.apache.james.transport.mailets.spf.explanation";
    public static final String RESULT_ATTRIBUTE = "org.apache.james.transport.mailets.spf.result";

    public void init() {
        this.addHeader = Boolean.valueOf(this.getInitParameter("addHeader", "false"));
        SPFLoggerAdapter logger = new SPFLoggerAdapter(Boolean.valueOf(this.getInitParameter("debug", "false")));
        this.spf = new DefaultSPF((Logger)logger);
    }

    public void service(Mail mail) throws MessagingException {
        String sender = null;
        MailAddress senderAddr = mail.getSender();
        String remoteAddr = mail.getRemoteAddr();
        String helo = mail.getRemoteHost();
        if (!remoteAddr.equals("127.0.0.1")) {
            sender = senderAddr != null ? senderAddr.toString() : "";
            SPFResult result = this.spf.checkSPF(remoteAddr, sender, helo);
            mail.setAttribute(EXPLANATION_ATTRIBUTE, (Serializable)((Object)result.getExplanation()));
            mail.setAttribute(RESULT_ATTRIBUTE, (Serializable)((Object)result.getResult()));
            this.log("ip:" + remoteAddr + " from:" + sender + " helo:" + helo + " = " + result.getResult());
            if (this.addHeader) {
                try {
                    MimeMessage msg = mail.getMessage();
                    msg.addHeader(result.getHeaderName(), result.getHeaderText());
                    msg.saveChanges();
                }
                catch (MessagingException e) {
                    // empty catch block
                }
            }
        }
    }

    private class SPFLoggerAdapter
    implements Logger {
        private boolean debug = false;
        private String name = "SPFLogger";

        public SPFLoggerAdapter(boolean debug) {
            this.debug = debug;
        }

        public SPFLoggerAdapter(String name, boolean debug) {
            this.name = name;
            this.debug = debug;
        }

        public void debug(String arg0) {
            if (this.debug) {
                SPF.this.log(arg0);
            }
        }

        public void debug(String arg0, Throwable arg1) {
            if (this.debug) {
                SPF.this.log(arg0, arg1);
            }
        }

        public void error(String arg0) {
            SPF.this.log(arg0);
        }

        public void error(String arg0, Throwable arg1) {
            SPF.this.log(arg0, arg1);
        }

        public void fatalError(String arg0) {
            SPF.this.log(arg0);
        }

        public void fatalError(String arg0, Throwable arg1) {
            SPF.this.log(arg0, arg1);
        }

        public Logger getChildLogger(String childName) {
            return new SPFLoggerAdapter(this.name + "." + childName, this.debug);
        }

        public void info(String arg0) {
            SPF.this.log(arg0);
        }

        public void info(String arg0, Throwable arg1) {
            SPF.this.log(arg0, arg1);
        }

        public boolean isDebugEnabled() {
            return this.debug;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalErrorEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void warn(String arg0) {
            SPF.this.log(arg0);
        }

        public void warn(String arg0, Throwable arg1) {
            SPF.this.log(arg0, arg1);
        }
    }
}

