/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.InputStream;
import java.util.Date;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MimeMessageInputStream;
import org.apache.james.mailbox.BadCredentialsException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.transport.mailets.ResourceLocatorImpl;
import org.apache.james.transport.util.MailetContextLog;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.jsieve.mailet.Poster;
import org.apache.jsieve.mailet.SieveMailboxMailet;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetConfig;
import org.slf4j.Logger;

public class SieveMailet
extends SieveMailboxMailet
implements Poster {
    private UsersRepository usersRepos;
    private MailboxManager mailboxManager;

    @Resource(name="usersrepository")
    public void setUsersRepository(UsersRepository usersRepos) {
        this.usersRepos = usersRepos;
    }

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public void init(MailetConfig config) throws MessagingException {
        try {
            this.setLocator(new ResourceLocatorImpl(this.usersRepos.supportVirtualHosting()));
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException("Unable to access UsersRepository", (Exception)((Object)e));
        }
        this.setPoster(this);
        super.init(config);
    }

    protected String getUsername(MailAddress m) {
        try {
            if (this.usersRepos.supportVirtualHosting()) {
                return m.toString();
            }
            return super.getUsername(m);
        }
        catch (UsersRepositoryException e) {
            this.log("Unable to access UsersRepository", e);
            return super.getUsername(m);
        }
    }

    public void storeMail(MailAddress sender, MailAddress recipient, Mail mail) throws MessagingException {
        super.storeMail(sender, recipient, mail);
        String s = sender != null ? sender.toString() : "<>";
        this.log("Local delivered mail " + mail.getName() + " sucessfully from " + s + " to " + recipient.toString());
    }

    public void post(String url, MimeMessage mail) throws MessagingException {
        int endOfScheme = url.indexOf(58);
        if (endOfScheme < 0) {
            throw new MessagingException("Malformed URI");
        }
        String scheme = url.substring(0, endOfScheme);
        if ("mailbox".equals(scheme)) {
            MailboxSession session;
            int startOfUser = endOfScheme + 3;
            int endOfUser = url.indexOf(64, startOfUser);
            if (endOfUser < 0) {
                throw new MessagingException("Shared mailbox is not supported");
            }
            String user = url.substring(startOfUser, endOfUser);
            int startOfHost = endOfUser + 1;
            int endOfHost = url.indexOf(47, startOfHost);
            String host = url.substring(startOfHost, endOfHost);
            int length = url.length();
            String urlPath = endOfHost + 1 == length ? "INBOX" : url.substring(endOfHost, length);
            try {
                if (this.usersRepos.supportVirtualHosting()) {
                    user = user + "@" + host;
                }
            }
            catch (UsersRepositoryException e) {
                throw new MessagingException("Unable to accessUsersRepository", (Exception)((Object)e));
            }
            try {
                session = this.mailboxManager.createSystemSession(user, (Logger)new MailetContextLog(this.getMailetContext()));
            }
            catch (BadCredentialsException e) {
                throw new MessagingException("Unable to authenticate to mailbox", (Exception)((Object)e));
            }
            catch (MailboxException e) {
                throw new MessagingException("Can not access mailbox", (Exception)((Object)e));
            }
            this.mailboxManager.startProcessingRequest(session);
            String destination = urlPath.replace('/', session.getPathDelimiter());
            if (destination == null || "".equals(destination)) {
                destination = "INBOX";
            }
            if (destination.startsWith(session.getPathDelimiter() + "")) {
                destination = destination.substring(1);
            }
            MailboxPath path = new MailboxPath("#private", user, destination);
            try {
                MessageManager mailbox;
                if ("INBOX".equalsIgnoreCase(destination) && !this.mailboxManager.mailboxExists(path, session)) {
                    this.mailboxManager.createMailbox(path, session);
                }
                if ((mailbox = this.mailboxManager.getMailbox(path, session)) == null) {
                    String error = "Mailbox for user " + user + " was not found on this server.";
                    throw new MessagingException(error);
                }
                mailbox.appendMessage((InputStream)new MimeMessageInputStream(mail), new Date(), session, true, null);
            }
            catch (MailboxException e) {
                throw new MessagingException("Unable to access mailbox.", (Exception)((Object)e));
            }
            finally {
                session.close();
                try {
                    this.mailboxManager.logout(session, true);
                }
                catch (MailboxException e) {
                    throw new MessagingException("Can logout from mailbox", (Exception)((Object)e));
                }
                this.mailboxManager.endProcessingRequest(session);
            }
        }
        throw new MessagingException("Unsupported protocol");
    }
}

