/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class ToRepository
extends GenericMailet {
    private MailRepository repository;
    private boolean passThrough = false;
    private String repositoryPath;
    private MailRepositoryStore mailStore;

    @Resource(name="mailrepositorystore")
    public void setStore(MailRepositoryStore mailStore) {
        this.mailStore = mailStore;
    }

    public void init() throws MessagingException {
        this.repositoryPath = this.getInitParameter("repositoryPath");
        try {
            this.passThrough = Boolean.valueOf(this.getInitParameter("passThrough"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.repository = this.mailStore.select(this.repositoryPath);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve MailRepository for url " + this.repositoryPath, e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        StringBuffer logBuffer = new StringBuffer(160).append("Storing mail ").append(mail.getName()).append(" in ").append(this.repositoryPath);
        this.log(logBuffer.toString());
        this.repository.store(mail);
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    public String getMailetInfo() {
        return "ToRepository Mailet";
    }
}

