/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.mailet.base.GenericMatcher;

public abstract class AbstractNetworkMatcher
extends GenericMatcher {
    private NetMatcher authorizedNetworks = null;
    private DNSService dnsServer;

    public void init() throws MessagingException {
        Collection<String> nets = this.allowedNetworks();
        if (nets != null) {
            this.authorizedNetworks = new NetMatcher(this.allowedNetworks(), this.dnsServer){

                protected void log(String s) {
                    AbstractNetworkMatcher.this.log(s);
                }
            };
            this.log("Authorized addresses: " + this.authorizedNetworks.toString());
        }
    }

    protected Collection<String> allowedNetworks() {
        ArrayList<String> networks = null;
        if (this.getCondition() != null) {
            StringTokenizer st = new StringTokenizer(this.getCondition(), ", ", false);
            networks = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                networks.add(st.nextToken());
            }
        }
        return networks;
    }

    protected boolean matchNetwork(InetAddress addr) {
        return this.authorizedNetworks == null ? false : this.authorizedNetworks.matchInetNetwork(addr);
    }

    protected boolean matchNetwork(String addr) {
        return this.authorizedNetworks == null ? false : this.authorizedNetworks.matchInetNetwork(addr);
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dnsService) {
        this.dnsServer = dnsService;
    }
}

