/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.james.mailbox.BadCredentialsException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxMetaData;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxQuery;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.util.FetchGroupImpl;
import org.apache.james.transport.matchers.AbstractQuotaMatcher;
import org.apache.james.transport.util.MailetContextLog;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public abstract class AbstractStorageQuota
extends AbstractQuotaMatcher {
    private MailboxManager manager;
    private UsersRepository localusers;
    private MailetContextLog log;

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager manager) {
        this.manager = manager;
    }

    @Resource(name="usersrepository")
    public void setUsersRepository(UsersRepository localusers) {
        this.localusers = localusers;
    }

    protected boolean isRecipientChecked(MailAddress recipient) throws MessagingException {
        MailetContext mailetContext = this.getMailetContext();
        return super.isRecipientChecked(recipient) && mailetContext.isLocalEmail(recipient);
    }

    public void init() throws MessagingException {
        super.init();
        this.log = new MailetContextLog(this.getMailetContext());
    }

    protected long getUsed(MailAddress recipient, Mail _) throws MessagingException {
        long size = 0L;
        try {
            String username;
            try {
                username = this.localusers.supportVirtualHosting() ? recipient.toString().toLowerCase(Locale.US) : recipient.getLocalPart().toLowerCase(Locale.US);
            }
            catch (UsersRepositoryException e) {
                throw new MessagingException("Unable to access UsersRepository", (Exception)((Object)e));
            }
            MailboxSession session = this.manager.createSystemSession(username, (Logger)this.log);
            this.manager.startProcessingRequest(session);
            List mList = this.manager.search(new MailboxQuery(MailboxPath.inbox((MailboxSession)session), "", session.getPathDelimiter()), session);
            for (int i = 0; i < mList.size(); ++i) {
                MessageManager mailbox = this.manager.getMailbox(((MailboxMetaData)mList.get(i)).getPath(), session);
                Iterator results = mailbox.getMessages(MessageRange.all(), (MessageResult.FetchGroup)new FetchGroupImpl(0), session);
                while (results.hasNext()) {
                    size += ((MessageResult)results.next()).getSize();
                }
            }
            this.manager.endProcessingRequest(session);
            this.manager.logout(session, true);
        }
        catch (BadCredentialsException e) {
            throw new MessagingException("Unable to authenticate to mailbox", (Exception)((Object)e));
        }
        catch (MailboxException e) {
            throw new MessagingException("Unable to get used space from mailbox", (Exception)((Object)e));
        }
        return size;
    }
}

