/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.AbstractSQLWhitelistMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class IsInWhiteList
extends AbstractSQLWhitelistMatcher {
    private String selectByPK;

    @Override
    public void init() throws MessagingException {
        super.init();
        this.selectByPK = this.sqlQueries.getSqlString("selectByPK", true);
    }

    @Override
    protected String getSQLSectionName() {
        return "WhiteList";
    }

    @Override
    protected boolean matchedWhitelist(MailAddress recipientMailAddress, Mail mail) throws MessagingException {
        ResultSet selectRS;
        PreparedStatement selectStmt;
        Connection conn;
        block12: {
            boolean bl;
            String recipientHost;
            String senderHost;
            block11: {
                String senderUser;
                block10: {
                    String recipientUser;
                    block9: {
                        MailAddress senderMailAddress = mail.getSender();
                        senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
                        senderHost = senderMailAddress.getDomain().toLowerCase(Locale.US);
                        conn = null;
                        selectStmt = null;
                        selectRS = null;
                        recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
                        recipientHost = recipientMailAddress.getDomain().toLowerCase(Locale.US);
                        if (conn == null) {
                            conn = this.datasource.getConnection();
                        }
                        if (selectStmt == null) {
                            selectStmt = conn.prepareStatement(this.selectByPK);
                        }
                        selectStmt.setString(1, recipientUser);
                        selectStmt.setString(2, recipientHost);
                        selectStmt.setString(3, senderUser);
                        selectStmt.setString(4, senderHost);
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) break block9;
                        boolean bl2 = true;
                        this.theJDBCUtil.closeJDBCResultSet(selectRS);
                        this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
                        this.theJDBCUtil.closeJDBCConnection(conn);
                        return bl2;
                    }
                    selectStmt = conn.prepareStatement(this.selectByPK);
                    selectStmt.setString(1, recipientUser);
                    selectStmt.setString(2, recipientHost);
                    selectStmt.setString(3, "*");
                    selectStmt.setString(4, senderHost);
                    selectRS = selectStmt.executeQuery();
                    if (!selectRS.next()) break block10;
                    boolean bl3 = true;
                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                    this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    return bl3;
                }
                selectStmt = conn.prepareStatement(this.selectByPK);
                selectStmt.setString(1, "*");
                selectStmt.setString(2, recipientHost);
                selectStmt.setString(3, senderUser);
                selectStmt.setString(4, senderHost);
                selectRS = selectStmt.executeQuery();
                if (!selectRS.next()) break block11;
                boolean bl4 = true;
                this.theJDBCUtil.closeJDBCResultSet(selectRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return bl4;
            }
            try {
                selectStmt = conn.prepareStatement(this.selectByPK);
                selectStmt.setString(1, "*");
                selectStmt.setString(2, recipientHost);
                selectStmt.setString(3, "*");
                selectStmt.setString(4, senderHost);
                selectRS = selectStmt.executeQuery();
                if (!selectRS.next()) break block12;
                bl = true;
            }
            catch (SQLException sqle) {
                try {
                    this.log("Error accessing database", sqle);
                    throw new MessagingException("Exception thrown", (Exception)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                    this.theJDBCUtil.closeJDBCStatement(selectStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
            this.theJDBCUtil.closeJDBCResultSet(selectRS);
            this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
            return bl;
        }
        this.theJDBCUtil.closeJDBCResultSet(selectRS);
        this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return false;
    }

    @Override
    protected String getTableCreateQueryName() {
        return "createWhiteListTable";
    }

    @Override
    protected String getTableName() {
        return "whiteListTableName";
    }
}

