/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.transport.matchers.AbstractNetworkMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class SenderInFakeDomain
extends AbstractNetworkMatcher {
    public Collection<MailAddress> match(Mail mail) {
        if (mail.getSender() == null) {
            return null;
        }
        String domain = mail.getSender().getDomain();
        Collection servers = this.getMailetContext().getMailServers(domain);
        if (servers.size() == 0) {
            this.log("No MX, A, or CNAME record found for domain: " + domain);
            return mail.getRecipients();
        }
        if (this.matchNetwork(((String)servers.iterator().next()).toString())) {
            this.log("Banned IP found for domain: " + domain);
            this.log(" --> :" + (String)servers.iterator().next());
            return mail.getRecipients();
        }
        return null;
    }
}

