/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import org.apache.mailet.MailetContext;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class MailetContextLog
implements Logger {
    private boolean isDebug;
    private MailetContext context;

    public MailetContextLog(MailetContext context, boolean isDebug) {
        this.context = context;
        this.isDebug = isDebug;
    }

    public MailetContextLog(MailetContext context) {
        this(context, false);
    }

    public void debug(String arg0) {
        if (this.isDebug) {
            this.debugLog(arg0, new Object[0]);
        }
    }

    public void debug(String arg0, Throwable arg1) {
        if (this.isDebug) {
            this.debugLog(arg0, arg1);
        }
    }

    public void error(String arg0) {
        this.errorLog(arg0, new Object[0]);
    }

    public void error(String arg0, Throwable arg1) {
        this.errorLog(arg0, arg1);
    }

    public void info(String arg0) {
        this.infoLog(arg0, new Object[0]);
    }

    public void info(String arg0, Throwable arg1) {
        this.infoLog(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        return this.isDebug;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Object arg0) {
    }

    public void trace(Object arg0, Throwable arg1) {
    }

    public void warn(String arg0) {
        this.warnLog(arg0, new Object[0]);
    }

    public void warn(String arg0, Throwable arg1) {
        this.warnLog(arg0, arg1);
    }

    public String getName() {
        return this.context.toString();
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void trace(String format, Object[] argArray) {
    }

    public void trace(String msg, Throwable t) {
    }

    public boolean isTraceEnabled(Marker marker) {
        return false;
    }

    public void trace(Marker marker, String msg) {
    }

    public void trace(Marker marker, String format, Object arg) {
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void trace(Marker marker, String format, Object[] argArray) {
    }

    public void trace(Marker marker, String msg, Throwable t) {
    }

    public void debug(String format, Object arg) {
        if (this.isDebug) {
            this.debugLog(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebug) {
            this.debugLog(format, arg1, arg2);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.isDebug) {
            this.debugLog(format, argArray);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebug;
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebug) {
            this.debugLog(marker, msg, new Object[0]);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebug) {
            this.debugLog(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebug) {
            this.debugLog(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        if (this.isDebug) {
            this.debugLog(marker, format, argArray);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebug) {
            this.debugLog(marker, msg, t);
        }
    }

    public void info(String format, Object arg) {
        this.infoLog(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.infoLog(format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.infoLog(format, argArray);
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(Marker marker, String msg) {
        this.infoLog(marker, msg, new Object[0]);
    }

    public void info(Marker marker, String format, Object arg) {
        this.infoLog(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.infoLog(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.infoLog(marker, format, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.infoLog(marker, msg, t);
    }

    public void warn(String format, Object arg) {
        this.warnLog(format, arg);
    }

    public void warn(String format, Object[] argArray) {
        this.warnLog(format, argArray);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warnLog(format, arg1, arg2);
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String msg) {
        this.warnLog(marker, msg, new Object[0]);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warnLog(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warnLog(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.warnLog(marker, format, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warnLog(marker, msg, t);
    }

    public void error(String format, Object arg) {
        this.errorLog(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.errorLog(format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.errorLog(format, argArray);
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String msg) {
        this.errorLog(marker, msg, new Object[0]);
    }

    public void error(Marker marker, String format, Object arg) {
        this.errorLog(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.errorLog(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.errorLog(marker, format, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.errorLog(marker, msg, t);
    }

    private void debugLog(Marker marker, String msg, Object ... obj) {
        StringBuffer s = new StringBuffer("[");
        s.append(marker.toString()).append("] ").append(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void debugLog(String msg, Object ... obj) {
        StringBuffer s = new StringBuffer(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void errorLog(Marker marker, String msg, Object ... obj) {
        StringBuffer s = new StringBuffer("[");
        s.append(marker.toString()).append("] ").append(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void errorLog(String msg, Object ... obj) {
        StringBuffer s = new StringBuffer(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void infoLog(Marker marker, String msg, Object ... obj) {
        StringBuffer s = new StringBuffer("[");
        s.append(marker.toString()).append("] ").append(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void infoLog(String msg, Object ... obj) {
        StringBuffer s = new StringBuffer(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void warnLog(Marker marker, String msg, Object ... obj) {
        StringBuffer s = new StringBuffer("[");
        s.append(marker.toString()).append("] ").append(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }

    private void warnLog(String msg, Object ... obj) {
        StringBuffer s = new StringBuffer(msg);
        Throwable t = null;
        if (obj != null) {
            s.append(" args=[");
            boolean first = true;
            for (Object o : obj) {
                if (o instanceof Throwable) {
                    t = (Throwable)o;
                    continue;
                }
                if (first) {
                    s.append(o.toString());
                    first = false;
                    continue;
                }
                s.append(", ").append(o.toString());
            }
            s.append("]");
        }
        if (t != null) {
            this.context.log(s.toString(), t);
        } else {
            this.context.log(s.toString());
        }
    }
}

