/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.BundleNames;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleReader {
    private static Logger log = LoggerFactory.getLogger(BundleReader.class);
    private static final TimeZone[] COMMON_TIMEZONES = new TimeZone[]{TimeZone.getTimeZone("GMT+00:00"), TimeZone.getTimeZone("GMT+01:00"), TimeZone.getTimeZone("GMT+02:00"), TimeZone.getTimeZone("GMT+03:00"), TimeZone.getTimeZone("GMT+04:00"), TimeZone.getTimeZone("GMT+05:00"), TimeZone.getTimeZone("GMT+06:00"), TimeZone.getTimeZone("GMT+07:00"), TimeZone.getTimeZone("GMT+08:00"), TimeZone.getTimeZone("GMT+09:00"), TimeZone.getTimeZone("GMT+10:00"), TimeZone.getTimeZone("GMT+11:00"), TimeZone.getTimeZone("GMT+12:00"), TimeZone.getTimeZone("GMT+13:00"), TimeZone.getTimeZone("GMT+14:00"), TimeZone.getTimeZone("GMT+15:00"), TimeZone.getTimeZone("GMT-16:00"), TimeZone.getTimeZone("GMT-15:00"), TimeZone.getTimeZone("GMT-14:00"), TimeZone.getTimeZone("GMT-13:00"), TimeZone.getTimeZone("GMT-12:00"), TimeZone.getTimeZone("GMT-11:00"), TimeZone.getTimeZone("GMT-10:00"), TimeZone.getTimeZone("GMT-09:00"), TimeZone.getTimeZone("GMT-08:00"), TimeZone.getTimeZone("GMT-07:00"), TimeZone.getTimeZone("GMT-06:00"), TimeZone.getTimeZone("GMT-05:00"), TimeZone.getTimeZone("GMT-04:00"), TimeZone.getTimeZone("GMT-03:00"), TimeZone.getTimeZone("GMT-02:00"), TimeZone.getTimeZone("GMT-01:00")};
    private final BundleBinding binding;
    private final CountingInputStream cin;
    private final DataInputStream in;
    private final int version;
    private final String[] namespaces = new String[]{"", null, null, null, null, null, null};

    public BundleReader(BundleBinding binding, InputStream stream) throws IOException {
        this.binding = binding;
        this.cin = new CountingInputStream(stream);
        this.in = new DataInputStream((InputStream)this.cin);
        this.version = this.in.readUnsignedByte();
    }

    public NodePropBundle readBundle(NodeId id) throws IOException {
        long start = this.cin.getByteCount();
        NodePropBundle bundle = new NodePropBundle(id);
        if (this.version >= 3) {
            this.readBundleNew(bundle);
        } else {
            this.readBundleOld(bundle);
        }
        bundle.setSize(this.cin.getByteCount() - start);
        return bundle;
    }

    private void readBundleNew(NodePropBundle bundle) throws IOException {
        int i;
        bundle.setNodeTypeName(this.readName());
        NodeId parentId = this.readNodeId();
        if (BundleBinding.NULL_PARENT_ID.equals(parentId)) {
            parentId = null;
        }
        bundle.setParentId(parentId);
        bundle.setModCount((short)this.readVarInt());
        int b = this.in.readUnsignedByte();
        bundle.setReferenceable((b & 1) != 0);
        int mn = this.readVarInt(b >> 7 & 1, 1);
        if (mn == 0) {
            bundle.setMixinTypeNames(Collections.<Name>emptySet());
        } else if (mn == 1) {
            bundle.setMixinTypeNames(Collections.singleton(this.readName()));
        } else {
            HashSet<Name> mixins = new HashSet<Name>(mn * 2);
            for (i = 0; i < mn; ++i) {
                mixins.add(this.readName());
            }
            bundle.setMixinTypeNames(mixins);
        }
        int pn = this.readVarInt(b >> 4 & 7, 7);
        for (i = 0; i < pn; ++i) {
            PropertyId id = new PropertyId(bundle.getId(), this.readName());
            bundle.addProperty(this.readPropertyEntry(id));
        }
        int nn = this.readVarInt(b >> 2 & 3, 3);
        for (int i2 = 0; i2 < nn; ++i2) {
            Name name = this.readQName();
            NodeId id = this.readNodeId();
            bundle.addChildNodeEntry(name, id);
        }
        int sn = this.readVarInt(b >> 1 & 1, 1);
        if (sn == 0) {
            bundle.setSharedSet(Collections.<NodeId>emptySet());
        } else if (sn == 1) {
            bundle.setSharedSet(Collections.singleton(this.readNodeId()));
        } else {
            HashSet<NodeId> shared = new HashSet<NodeId>();
            for (int i3 = 0; i3 < sn; ++i3) {
                shared.add(this.readNodeId());
            }
            bundle.setSharedSet(shared);
        }
    }

    private void readBundleOld(NodePropBundle bundle) throws IOException {
        int a = this.in.readUnsignedByte();
        int b = this.in.readUnsignedByte();
        int c = this.in.readUnsignedByte();
        String uri = this.binding.nsIndex.indexToString(a << 16 | b << 8 | c);
        String local = this.binding.nameIndex.indexToString(this.in.readInt());
        bundle.setNodeTypeName(NameFactoryImpl.getInstance().create(uri, local));
        bundle.setParentId(this.readNodeId());
        this.in.readUTF();
        Name name = this.readIndexedQName();
        if (name != null) {
            HashSet<Name> mixinTypeNames = new HashSet<Name>();
            do {
                mixinTypeNames.add(name);
            } while ((name = this.readIndexedQName()) != null);
            bundle.setMixinTypeNames(mixinTypeNames);
        } else {
            bundle.setMixinTypeNames(Collections.<Name>emptySet());
        }
        name = this.readIndexedQName();
        while (name != null) {
            PropertyId pId = new PropertyId(bundle.getId(), name);
            NodePropBundle.PropertyEntry pState = this.readPropertyEntry(pId);
            if (!(name.equals(NameConstants.JCR_PRIMARYTYPE) || name.equals(NameConstants.JCR_MIXINTYPES) || name.equals(NameConstants.JCR_UUID))) {
                bundle.addProperty(pState);
            }
            name = this.readIndexedQName();
        }
        bundle.setReferenceable(this.in.readBoolean());
        NodeId childId = this.readNodeId();
        while (childId != null) {
            bundle.addChildNodeEntry(this.readQName(), childId);
            childId = this.readNodeId();
        }
        if (this.version >= 1) {
            bundle.setModCount(this.in.readShort());
        }
        if (this.version >= 2) {
            NodeId parentId = this.readNodeId();
            if (parentId != null) {
                HashSet<NodeId> shared = new HashSet<NodeId>();
                do {
                    shared.add(parentId);
                } while ((parentId = this.readNodeId()) != null);
                bundle.setSharedSet(shared);
            } else {
                bundle.setSharedSet(Collections.<NodeId>emptySet());
            }
        } else {
            bundle.setSharedSet(Collections.<NodeId>emptySet());
        }
    }

    private NodePropBundle.PropertyEntry readPropertyEntry(PropertyId id) throws IOException {
        NodePropBundle.PropertyEntry entry = new NodePropBundle.PropertyEntry(id);
        int count = 1;
        if (this.version >= 3) {
            int b = this.in.readUnsignedByte();
            entry.setType(b & 0xF);
            int len = b >>> 4;
            if (len != 0) {
                entry.setMultiValued(true);
                count = len == 15 ? this.readVarInt() + 15 - 1 : len - 1;
            }
            entry.setModCount((short)this.readVarInt());
        } else {
            int type = this.in.readInt();
            entry.setModCount((short)(type >> 16 & 0xFFFF));
            entry.setType(type &= 0xFFFF);
            entry.setMultiValued(this.in.readBoolean());
            this.in.readUTF();
            count = this.in.readInt();
        }
        InternalValue[] values = new InternalValue[count];
        String[] blobIds = new String[count];
        for (int i = 0; i < count; ++i) {
            InternalValue val;
            switch (entry.getType()) {
                case 2: {
                    int size = this.in.readInt();
                    if (size == -2) {
                        val = InternalValue.create(this.binding.dataStore, this.readString());
                        break;
                    }
                    if (size == -1) {
                        blobIds[i] = this.readString();
                        try {
                            BLOBStore blobStore = this.binding.getBlobStore();
                            if (blobStore instanceof ResourceBasedBLOBStore) {
                                val = InternalValue.create(((ResourceBasedBLOBStore)blobStore).getResource(blobIds[i]));
                                break;
                            }
                            val = InternalValue.create(blobStore.get(blobIds[i]));
                            break;
                        }
                        catch (IOException e) {
                            if (this.binding.errorHandling.ignoreMissingBlobs()) {
                                log.warn("Ignoring error while reading blob-resource: " + e);
                                val = InternalValue.create(new byte[0]);
                                break;
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException("Unable to create property value: " + e.toString());
                        }
                    }
                    byte[] data = new byte[size];
                    this.in.readFully(data);
                    val = InternalValue.create(data);
                    break;
                }
                case 4: {
                    val = InternalValue.create(this.in.readDouble());
                    break;
                }
                case 12: {
                    val = InternalValue.create(this.readDecimal());
                    break;
                }
                case 3: {
                    if (this.version >= 3) {
                        val = InternalValue.create(this.readVarLong());
                        break;
                    }
                    val = InternalValue.create(this.in.readLong());
                    break;
                }
                case 6: {
                    val = InternalValue.create(this.in.readBoolean());
                    break;
                }
                case 7: {
                    val = InternalValue.create(this.readQName());
                    break;
                }
                case 10: {
                    val = InternalValue.create(this.readNodeId(), true);
                    break;
                }
                case 9: {
                    val = InternalValue.create(this.readNodeId(), false);
                    break;
                }
                case 5: {
                    if (this.version >= 3) {
                        val = InternalValue.create(this.readDate());
                        break;
                    }
                }
                default: {
                    if (this.version >= 3) {
                        val = InternalValue.valueOf(this.readString(), entry.getType());
                        break;
                    }
                    int len = this.in.readInt();
                    byte[] bytes = new byte[len];
                    this.in.readFully(bytes);
                    val = InternalValue.valueOf(new String(bytes, "UTF-8"), entry.getType());
                }
            }
            values[i] = val;
        }
        entry.setValues(values);
        entry.setBlobIds(blobIds);
        return entry;
    }

    private NodeId readNodeId() throws IOException {
        if (this.version >= 3 || this.in.readBoolean()) {
            long msb = this.in.readLong();
            long lsb = this.in.readLong();
            return new NodeId(msb, lsb);
        }
        return null;
    }

    private BigDecimal readDecimal() throws IOException {
        if (this.in.readBoolean()) {
            return new BigDecimal(this.readString());
        }
        return null;
    }

    private Name readQName() throws IOException {
        if (this.version >= 3) {
            return this.readName();
        }
        String uri = this.binding.nsIndex.indexToString(this.in.readInt());
        String local = this.in.readUTF();
        return NameFactoryImpl.getInstance().create(uri, local);
    }

    private Name readIndexedQName() throws IOException {
        if (this.version >= 3) {
            return this.readName();
        }
        int index = this.in.readInt();
        if (index < 0) {
            return null;
        }
        String uri = this.binding.nsIndex.indexToString(index);
        String local = this.binding.nameIndex.indexToString(this.in.readInt());
        return NameFactoryImpl.getInstance().create(uri, local);
    }

    private Name readName() throws IOException {
        String uri;
        int b = this.in.readUnsignedByte();
        if ((b & 0x80) == 0) {
            return BundleNames.indexToName(b);
        }
        int ns = b >> 4 & 7;
        if (ns < this.namespaces.length && this.namespaces[ns] != null) {
            uri = this.namespaces[ns];
        } else {
            uri = this.readString();
            if (ns < this.namespaces.length) {
                this.namespaces[ns] = uri;
            }
        }
        String local = new String(this.readBytes((b & 0xF) + 1, 16), "UTF-8");
        return NameFactoryImpl.getInstance().create(uri, local);
    }

    private int readVarInt() throws IOException {
        int b = this.in.readUnsignedByte();
        if ((b & 0x80) == 0) {
            return b;
        }
        return this.readVarInt() << 7 | b & 0x7F;
    }

    private int readVarInt(int value, int base) throws IOException {
        if (value < base) {
            return value;
        }
        return this.readVarInt() + base;
    }

    private long readVarLong() throws IOException {
        long b;
        long value = 0L;
        int bits = 0;
        do {
            b = this.in.readUnsignedByte();
            value = (b & 0x7FL) << 57 | value >>> 7;
            bits += 7;
        } while ((b & 0x80L) != 0L);
        if (((value >>>= 64 - bits) & 1L) != 0L) {
            return value >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return value >>> 1;
    }

    private Calendar readDate() throws IOException {
        TimeZone tz;
        long ts = this.readVarLong();
        if ((ts & 1L) == 0L) {
            tz = COMMON_TIMEZONES[0];
            ts >>= 1;
        } else if ((ts & 2L) == 0L) {
            tz = COMMON_TIMEZONES[(int)ts >> 2 & 0x1F];
            ts >>= 7;
        } else {
            int m = (int)ts << 19 >> 21;
            int h = m / 60;
            String s = m < 0 ? String.format("GMT-%02d:%02d", -h, h * 60 - m) : String.format("GMT+%02d:%02d", h, m - h * 60);
            tz = TimeZone.getTimeZone(s);
            ts >>= 13;
        }
        int u = 0;
        int s = 0;
        int m = 0;
        int h = 0;
        int type = (int)ts & 3;
        ts >>= 2;
        switch (type) {
            case 3: {
                u = (int)ts & 0x3FFFFFFF;
                s = u / 1000;
                m = s / 60;
                h = m / 60;
                u -= ((h * 60 + m) * 60 + (s -= (h * 60 + (m -= h * 60)) * 60)) * 1000;
                ts >>= 30;
                break;
            }
            case 2: {
                m = (int)ts & 0x7FF;
                h = m / 60;
                m -= h * 60;
                ts >>= 11;
                break;
            }
            case 1: {
                h = (int)ts & 0x1F;
                ts >>= 5;
            }
        }
        int d = (int)ts & 0x1FF;
        int y = (int)((ts >>= 9) + 2010L);
        Calendar value = Calendar.getInstance(tz);
        if (y <= 0) {
            value.set(1, 1 - y);
            value.set(0, 0);
        } else {
            value.set(1, y);
            value.set(0, 1);
        }
        value.set(6, d);
        value.set(11, h);
        value.set(12, m);
        value.set(13, s);
        value.set(14, u);
        return value;
    }

    private String readString() throws IOException {
        if (this.version >= 3) {
            return new String(this.readBytes(0, 0), "UTF-8");
        }
        return this.in.readUTF();
    }

    private byte[] readBytes(int len, int base) throws IOException {
        byte[] bytes = new byte[this.readVarInt(len, base)];
        this.in.readFully(bytes);
        return bytes;
    }
}

