/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.image.ImageParser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JackrabbitParser
implements Parser {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitParser.class);
    private static volatile boolean blocked = false;
    private final AutoDetectParser parser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JackrabbitParser() {
        block6: {
            InputStream stream = JackrabbitParser.class.getResourceAsStream("tika-config.xml");
            try {
                if (stream != null) {
                    try {
                        this.parser = new AutoDetectParser(new TikaConfig(stream));
                        break block6;
                    }
                    finally {
                        stream.close();
                    }
                }
                this.parser = new AutoDetectParser();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load embedded Tika configuration", e);
            }
        }
    }

    public void setTextFilterClasses(String classes) {
        HashMap<MediaType, Object> parsers = new HashMap<MediaType, Object>();
        StringTokenizer tokenizer = new StringTokenizer(classes, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            OfficeParser parser;
            String name = tokenizer.nextToken();
            if (name.equals("org.apache.jackrabbit.extractor.HTMLTextExtractor")) {
                parsers.put(MediaType.text((String)"html"), new HtmlParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsExcelTextExtractor")) {
                parser = new OfficeParser();
                parsers.put(MediaType.application((String)"vnd.ms-excel"), parser);
                parsers.put(MediaType.application((String)"msexcel"), parser);
                parsers.put(MediaType.application((String)"excel"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsOutlookTextExtractor")) {
                parsers.put(MediaType.application((String)"vnd.ms-outlook"), new OfficeParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsPowerPointExtractor") || name.equals("org.apache.jackrabbit.extractor.MsPowerPointTextExtractor")) {
                parser = new OfficeParser();
                parsers.put(MediaType.application((String)"vnd.ms-powerpoint"), parser);
                parsers.put(MediaType.application((String)"mspowerpoint"), parser);
                parsers.put(MediaType.application((String)"powerpoint"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsWordTextExtractor")) {
                parser = new OfficeParser();
                parsers.put(MediaType.application((String)"vnd.ms-word"), parser);
                parsers.put(MediaType.application((String)"msword"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.MsTextExtractor")) {
                parser = new OfficeParser();
                parsers.put(MediaType.application((String)"vnd.ms-word"), parser);
                parsers.put(MediaType.application((String)"msword"), parser);
                parsers.put(MediaType.application((String)"vnd.ms-powerpoint"), parser);
                parsers.put(MediaType.application((String)"mspowerpoint"), parser);
                parsers.put(MediaType.application((String)"vnd.ms-excel"), parser);
                parsers.put(MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.document"), parser);
                parsers.put(MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.presentation"), parser);
                parsers.put(MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.sheet"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.OpenOfficeTextExtractor")) {
                parser = new OpenDocumentParser();
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.database"), parser);
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.formula"), parser);
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.graphics"), parser);
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.presentation"), parser);
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.spreadsheet"), parser);
                parsers.put(MediaType.application((String)"vnd.oasis.opendocument.text"), parser);
                parsers.put(MediaType.application((String)"vnd.sun.xml.calc"), parser);
                parsers.put(MediaType.application((String)"vnd.sun.xml.draw"), parser);
                parsers.put(MediaType.application((String)"vnd.sun.xml.impress"), parser);
                parsers.put(MediaType.application((String)"vnd.sun.xml.writer"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PdfTextExtractor")) {
                parsers.put(MediaType.application((String)"pdf"), new PDFParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PlainTextExtractor")) {
                parsers.put(MediaType.TEXT_PLAIN, new TXTParser());
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.PngTextExtractor")) {
                parser = new ImageParser();
                parsers.put(MediaType.image((String)"png"), parser);
                parsers.put(MediaType.image((String)"apng"), parser);
                parsers.put(MediaType.image((String)"mng"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.RTFTextExtractor")) {
                parser = new RTFParser();
                parsers.put(MediaType.application((String)"rtf"), parser);
                parsers.put(MediaType.text((String)"rtf"), parser);
                continue;
            }
            if (name.equals("org.apache.jackrabbit.extractor.XMLTextExtractor")) {
                parser = new XMLParser();
                parsers.put(MediaType.APPLICATION_XML, parser);
                parsers.put(MediaType.text((String)"xml"), parser);
                continue;
            }
            logger.warn("Ignoring unknown text extractor class: {}", (Object)name);
        }
        this.parser.setParsers(parsers);
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.parser.getSupportedTypes(context);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        JackrabbitParser.waitIfBlocked();
        this.parser.parse(stream, handler, metadata, context);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private static synchronized void waitIfBlocked() throws TikaException {
        try {
            while (blocked) {
                JackrabbitParser.class.wait();
            }
        }
        catch (InterruptedException e) {
            throw new TikaException("Text extraction block interrupted", (Throwable)e);
        }
    }

    static synchronized void block() {
        blocked = true;
    }

    static synchronized void unblock() {
        blocked = false;
        JackrabbitParser.class.notifyAll();
    }
}

