/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.transaction.Mapper;

public class InMemoryMailboxMapper
implements MailboxMapper<Long> {
    private static final int INITIAL_SIZE = 128;
    private final Map<Long, Mailbox<Long>> mailboxesById = new ConcurrentHashMap<Long, Mailbox<Long>>(128);
    private static final AtomicLong IDS = new AtomicLong();

    public void delete(Mailbox<Long> mailbox) throws MailboxException {
        this.mailboxesById.remove(mailbox.getMailboxId());
    }

    public void deleteAll() throws MailboxException {
        this.mailboxesById.clear();
    }

    public synchronized Mailbox<Long> findMailboxByPath(MailboxPath path) throws MailboxException, MailboxNotFoundException {
        Mailbox<Long> result = null;
        for (Mailbox<Long> mailbox : this.mailboxesById.values()) {
            MailboxPath mp = new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), mailbox.getName());
            if (!mp.equals((Object)path)) continue;
            result = mailbox;
            break;
        }
        if (result == null) {
            throw new MailboxNotFoundException(path);
        }
        return result;
    }

    public List<Mailbox<Long>> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        String regex = path.getName().replace("%", ".*");
        ArrayList<Mailbox<Long>> results = new ArrayList<Mailbox<Long>>();
        for (Mailbox<Long> mailbox : this.mailboxesById.values()) {
            if (!mailbox.getName().matches(regex)) continue;
            results.add(mailbox);
        }
        return results;
    }

    public void save(Mailbox<Long> mailbox) throws MailboxException {
        Long id = (Long)mailbox.getMailboxId();
        if (id == null) {
            id = IDS.incrementAndGet();
            ((SimpleMailbox)mailbox).setMailboxId((Object)id);
        }
        this.mailboxesById.put(id, mailbox);
    }

    public void endRequest() {
    }

    public boolean hasChildren(Mailbox<Long> mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        String mailboxName = mailbox.getName() + delimiter;
        for (Mailbox<Long> box : this.mailboxesById.values()) {
            if (!box.getName().startsWith(mailboxName)) continue;
            return true;
        }
        return false;
    }

    public List<Mailbox<Long>> list() throws MailboxException {
        return new ArrayList<Mailbox<Long>>(this.mailboxesById.values());
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }
}

