/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMessage;

public class InMemoryMessageMapper
extends AbstractMessageMapper<Long> {
    private Map<Long, Map<Long, Message<Long>>> mailboxByUid = new ConcurrentHashMap<Long, Map<Long, Message<Long>>>(256);
    private static final int INITIAL_SIZE = 256;

    public InMemoryMessageMapper(MailboxSession session, UidProvider<Long> uidProvider, ModSeqProvider<Long> modSeqProvider) {
        super(session, uidProvider, modSeqProvider);
    }

    private Map<Long, Message<Long>> getMembershipByUidForMailbox(Mailbox<Long> mailbox) {
        Map<Long, Message<Long>> membershipByUid = this.mailboxByUid.get(mailbox.getMailboxId());
        if (membershipByUid == null) {
            membershipByUid = new ConcurrentHashMap<Long, Message<Long>>(256);
            this.mailboxByUid.put((Long)mailbox.getMailboxId(), membershipByUid);
        }
        return membershipByUid;
    }

    public long countMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        return this.getMembershipByUidForMailbox(mailbox).size();
    }

    public long countUnseenMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        long count = 0L;
        for (Message<Long> member : this.getMembershipByUidForMailbox(mailbox).values()) {
            if (member.isSeen()) continue;
            ++count;
        }
        return count;
    }

    public void delete(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        this.getMembershipByUidForMailbox(mailbox).remove(message.getUid());
    }

    public void findInMailbox(Mailbox<Long> mailbox, MessageRange set, MessageMapper.FetchType ftype, MessageMapper.MessageCallback<Long> callback) throws MailboxException {
        ArrayList<Object> results;
        int batchSize = set.getBatchSize();
        MessageRange.Type type = set.getType();
        switch (type) {
            case ALL: {
                results = new ArrayList<Message<Long>>(this.getMembershipByUidForMailbox(mailbox).values());
                break;
            }
            case FROM: {
                results = new ArrayList<Message<Long>>(this.getMembershipByUidForMailbox(mailbox).values());
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    if (((Message)it.next()).getUid() >= set.getUidFrom()) continue;
                    it.remove();
                }
                break;
            }
            case RANGE: {
                results = new ArrayList<Message<Long>>(this.getMembershipByUidForMailbox(mailbox).values());
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    long uid = ((Message)it.next()).getUid();
                    if (uid >= set.getUidFrom() && uid <= set.getUidTo()) continue;
                    it.remove();
                }
                break;
            }
            case ONE: {
                results = new ArrayList(1);
                Message<Long> member = this.getMembershipByUidForMailbox(mailbox).get(set.getUidFrom());
                if (member == null) break;
                results.add(member);
                break;
            }
            default: {
                results = new ArrayList();
            }
        }
        Collections.sort(results);
        if (batchSize > 0) {
            int i = 0;
            while (i * batchSize < results.size()) {
                callback.onMessages(results.subList(i * batchSize, (i + 1) * batchSize < results.size() ? (i + 1) * batchSize : results.size()));
                ++i;
            }
        } else {
            callback.onMessages(results);
        }
    }

    public List<Long> findRecentMessageUidsInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Message<Long> member : this.getMembershipByUidForMailbox(mailbox).values()) {
            if (!member.isRecent()) continue;
            results.add(member.getUid());
        }
        Collections.sort(results);
        return results;
    }

    public Long findFirstUnseenMessageUid(Mailbox<Long> mailbox) throws MailboxException {
        ArrayList<Message<Long>> memberships = new ArrayList<Message<Long>>(this.getMembershipByUidForMailbox(mailbox).values());
        Collections.sort(memberships);
        for (int i = 0; i < memberships.size(); ++i) {
            Message m = (Message)memberships.get(i);
            if (m.isSeen()) continue;
            return m.getUid();
        }
        return null;
    }

    public void deleteAll() {
        this.mailboxByUid.clear();
    }

    public void endRequest() {
    }

    protected MessageMetaData copy(Mailbox<Long> mailbox, long uid, long modSeq, Message<Long> original) throws MailboxException {
        SimpleMessage message = new SimpleMessage(mailbox, original);
        message.setUid(uid);
        message.setModSeq(modSeq);
        Flags flags = original.createFlags();
        flags.add(Flags.Flag.RECENT);
        message.setFlags(flags);
        return this.save(mailbox, (Message<Long>)message);
    }

    protected MessageMetaData save(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        SimpleMessage copy = new SimpleMessage(mailbox, message);
        copy.setUid(message.getUid());
        copy.setModSeq(message.getModSeq());
        this.getMembershipByUidForMailbox(mailbox).put(message.getUid(), (Message<Long>)copy);
        return new SimpleMessageMetaData(message);
    }

    protected void begin() throws MailboxException {
    }

    protected void commit() throws MailboxException {
    }

    protected void rollback() throws MailboxException {
    }

    public Map<Long, MessageMetaData> expungeMarkedForDeletionInMailbox(final Mailbox<Long> mailbox, MessageRange set) throws MailboxException {
        final HashMap<Long, MessageMetaData> filteredResult = new HashMap<Long, MessageMetaData>();
        this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, new MessageMapper.MessageCallback<Long>(){

            public void onMessages(List<Message<Long>> results) throws MailboxException {
                for (Message<Long> member : results) {
                    if (!member.isDeleted()) continue;
                    filteredResult.put(member.getUid(), new SimpleMessageMetaData(member));
                    InMemoryMessageMapper.this.delete((Mailbox<Long>)mailbox, member);
                }
            }
        });
        return filteredResult;
    }
}

