/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class InMemoryModSeqProvider
implements ModSeqProvider<Long> {
    private final ConcurrentMap<Long, AtomicLong> map = new ConcurrentHashMap<Long, AtomicLong>();

    public long nextModSeq(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        return this.getHighest((Long)mailbox.getMailboxId()).incrementAndGet();
    }

    public long highestModSeq(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        return this.getHighest((Long)mailbox.getMailboxId()).get();
    }

    private AtomicLong getHighest(Long id) {
        AtomicLong u;
        AtomicLong uid = (AtomicLong)this.map.get(id);
        if (uid == null && (u = this.map.putIfAbsent(id, uid = new AtomicLong(0L))) != null) {
            uid = u;
        }
        return uid;
    }
}

