/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class InMemoryUidProvider
implements UidProvider<Long> {
    private final ConcurrentMap<Long, AtomicLong> map = new ConcurrentHashMap<Long, AtomicLong>();

    public long nextUid(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        return this.getLast((Long)mailbox.getMailboxId()).incrementAndGet();
    }

    public long lastUid(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        return this.getLast((Long)mailbox.getMailboxId()).get();
    }

    private AtomicLong getLast(Long id) {
        AtomicLong u;
        AtomicLong uid = (AtomicLong)this.map.get(id);
        if (uid == null && (u = this.map.putIfAbsent(id, uid = new AtomicLong(0L))) != null) {
            uid = u;
        }
        return uid;
    }
}

