/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.interceptor.Fault;
import org.apache.log4j.Logger;
import org.ow2.choreos.chors.Configuration;
import org.ow2.choreos.chors.EnactmentException;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographyService;
import org.ow2.choreos.chors.datamodel.ChoreographyServiceSpec;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.client.NodesClient;
import org.ow2.choreos.services.ServiceNotDeployedException;
import org.ow2.choreos.services.ServiceNotModifiedException;
import org.ow2.choreos.services.ServicesManager;
import org.ow2.choreos.services.UnhandledModificationException;
import org.ow2.choreos.services.client.ServicesClient;
import org.ow2.choreos.services.datamodel.DeployableService;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.PackageType;
import org.ow2.choreos.services.datamodel.Service;
import org.ow2.choreos.services.datamodel.ServiceInstance;

public class Deployer {
    private Logger logger = Logger.getLogger(Deployer.class);
    private volatile ServicesManager servicesManager = new ServicesClient(Configuration.get(Configuration.Option.DEPLOYMENT_MANAGER_URI));

    public Map<String, ChoreographyService> deployChoreographyServices(Choreography chor) throws EnactmentException {
        this.logger.info((Object)("Starting to deploy services of choreography " + chor.getId()));
        this.logger.info((Object)"Request to configure nodes; creating services; setting up Chef");
        List<ChoreographyService> choreographyServices = this.configureNodes(chor);
        if (choreographyServices == null) {
            this.logger.info((Object)"Deployer got a null list of choreography services; Verify if the DeploymentManager is up");
            throw new EnactmentException("Probably DeploymentManager is off. Deployer got a null list of choreography services");
        }
        if (choreographyServices.isEmpty()) {
            this.logger.info((Object)"Deployer got a empty list of choreography services; Verify if the DeploymentManager is up");
            throw new EnactmentException("Probably DeploymentManager is off. Deployer got a null list of choreography services");
        }
        this.logger.info((Object)"Nodes are configured to run chef-client");
        this.logger.info((Object)"Requested to run chef-client on nodes");
        Map<String, ChoreographyService> deployedServices = this.runChefClient(choreographyServices);
        if (deployedServices == null) {
            this.logger.info((Object)"Deployed service list became null after run chef-client");
            throw new EnactmentException("Deployed service list became null after run chef-client");
        }
        if (choreographyServices.isEmpty()) {
            this.logger.info((Object)"eployed service list became empty after run chef-client");
            throw new EnactmentException("eployed service list became empty after run chef-client");
        }
        this.logger.info((Object)"Deployement finished");
        return deployedServices;
    }

    private List<ChoreographyService> configureNodes(Choreography chor) {
        if (chor.getChoreographyServices() == null || chor.getChoreographyServices().isEmpty()) {
            return this.deployNewServices(chor.getRequestedChoreographySpec().getChoreographyServiceSpecs());
        }
        return this.updateAndDeployServices(chor);
    }

    private List<ChoreographyService> deployNewServices(List<ChoreographyServiceSpec> list) {
        int TIMEOUT = 8;
        int N = list.size();
        ExecutorService executor = Executors.newFixedThreadPool(N);
        HashMap<ChoreographyServiceSpec, Future<ChoreographyService>> futures = new HashMap<ChoreographyServiceSpec, Future<ChoreographyService>>();
        for (ChoreographyServiceSpec choreographyServiceSpec : list) {
            this.logger.debug((Object)("Requesting deploy of " + choreographyServiceSpec));
            ServicesManagerInvoker invoker = new ServicesManagerInvoker(choreographyServiceSpec);
            Future<ChoreographyService> future = executor.submit(invoker);
            futures.put(choreographyServiceSpec, future);
        }
        this.waitExecutor(executor, 8);
        ArrayList<ChoreographyService> services = new ArrayList<ChoreographyService>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ChoreographyService service = (ChoreographyService)this.checkFuture((Future)entry.getValue());
                if (service == null) continue;
                services.add(service);
            }
            catch (Exception e) {
                this.logger.error((Object)("Could not get service from future: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return services;
    }

    private <T> T checkFuture(Future<T> f) throws Exception {
        T result = null;
        try {
            if (!f.isDone()) {
                throw new Exception();
            }
            result = f.get();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw e;
        }
        return result;
    }

    private Map<String, ChoreographyService> runChefClient(List<ChoreographyService> services) {
        int TIMEOUT = 10;
        int N = services.size();
        ExecutorService executor = Executors.newFixedThreadPool(N);
        HashMap<String, ChoreographyService> deployedServices = new HashMap<String, ChoreographyService>();
        for (ChoreographyService deployed : services) {
            deployedServices.put(deployed.getChoreographyServiceSpec().getChoreographyServiceUID(), deployed);
            if (deployed.getChoreographyServiceSpec().getServiceSpec().getPackageType() == PackageType.LEGACY) continue;
            for (ServiceInstance instance : ((DeployableService)deployed.getService()).getInstances()) {
                String nodeId = instance.getNode().getId();
                NodeUpgrader upgrader = new NodeUpgrader(nodeId);
                executor.submit(upgrader);
            }
        }
        this.waitExecutor(executor, 10);
        return deployedServices;
    }

    private void waitExecutor(ExecutorService executor, int timeoutMinutes) {
        executor.shutdown();
        boolean status = false;
        try {
            status = executor.awaitTermination(timeoutMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Interrupted thread! Should not happen!", (Throwable)e);
        }
        if (!status) {
            this.logger.info((Object)"Executor status is False. Probably there is some problem!.");
        }
        executor.shutdownNow();
    }

    private Map<String, ChoreographyServiceSpec> makeMapFromServiceList(List<ChoreographyServiceSpec> list) {
        HashMap<String, ChoreographyServiceSpec> result = new HashMap<String, ChoreographyServiceSpec>();
        for (ChoreographyServiceSpec spec : list) {
            result.put(spec.getChoreographyServiceUID(), spec);
        }
        return result;
    }

    private Map<String, ChoreographyService> getServicesForChor(Choreography chor) {
        HashMap<String, ChoreographyService> currentServices = new HashMap<String, ChoreographyService>();
        for (ChoreographyService s : chor.getChoreographyServices()) {
            currentServices.put(s.getChoreographyServiceSpec().getChoreographyServiceUID(), s);
        }
        return currentServices;
    }

    private List<ChoreographyService> updateAndDeployServices(Choreography chor) {
        Map<String, ChoreographyServiceSpec> requestedSpecMap = this.makeMapFromServiceList(chor.getRequestedChoreographySpec().getChoreographyServiceSpecs());
        Map<String, ChoreographyService> currentServices = this.getServicesForChor(chor);
        HashMap<String, ChoreographyServiceSpec> toUpdate = new HashMap<String, ChoreographyServiceSpec>();
        ArrayList<ChoreographyServiceSpec> toCreate = new ArrayList<ChoreographyServiceSpec>();
        ArrayList<ChoreographyService> updatedServiceList = new ArrayList<ChoreographyService>();
        for (Map.Entry<String, ChoreographyService> entry : currentServices.entrySet()) {
            ChoreographyServiceSpec requestedSpec = requestedSpecMap.get(entry.getKey());
            if (requestedSpec == null) continue;
            if (!requestedSpec.equals((Object)entry.getValue().getChoreographyServiceSpec())) {
                toUpdate.put(entry.getValue().getChoreographyServiceSpec().getChoreographyServiceUID(), requestedSpec);
                continue;
            }
            updatedServiceList.add(entry.getValue());
        }
        for (Map.Entry<String, ChoreographyService> entry : requestedSpecMap.entrySet()) {
            if (currentServices.containsKey(entry.getKey())) continue;
            toCreate.add((ChoreographyServiceSpec)entry.getValue());
        }
        updatedServiceList.addAll(this.doUpdate(chor, toUpdate, toCreate));
        return updatedServiceList;
    }

    private List<ChoreographyService> doUpdate(Choreography chor, Map<String, ChoreographyServiceSpec> toUpdate, List<ChoreographyServiceSpec> toCreate) {
        List<ChoreographyService> b = new ArrayList<ChoreographyService>();
        if (toUpdate.size() > 0) {
            b = this.updateExistingServices(chor, toUpdate);
        }
        if (toCreate.size() > 0) {
            List<ChoreographyService> a = this.deployNewServices(toCreate);
            b.addAll(a);
        }
        return b;
    }

    private List<ChoreographyService> updateExistingServices(Choreography chor, Map<String, ChoreographyServiceSpec> toUpdate) {
        int TIMEOUT = 10;
        int N = toUpdate.size();
        ExecutorService executor = Executors.newFixedThreadPool(N);
        HashMap<ChoreographyServiceSpec, Future<ChoreographyService>> futures = new HashMap<ChoreographyServiceSpec, Future<ChoreographyService>>();
        for (Map.Entry<String, ChoreographyServiceSpec> serviceSpec : toUpdate.entrySet()) {
            this.logger.debug((Object)("Requesting update of " + serviceSpec));
            ChoreographyService chorService = chor.getDeployedChoreographyServiceByChoreographyServiceUID(serviceSpec.getKey());
            ChoreographyServiceSpec tmp = serviceSpec.getValue();
            tmp.getServiceSpec().setUUID(chorService.getChoreographyServiceSpec().getServiceSpec().getUUID());
            chorService.setChoreographyServiceSpec(tmp);
            ServiceUpdateInvoker invoker = new ServiceUpdateInvoker(chorService);
            Future<ChoreographyService> future = executor.submit(invoker);
            futures.put(serviceSpec.getValue(), future);
        }
        this.waitExecutor(executor, 10);
        ArrayList<ChoreographyService> services = new ArrayList<ChoreographyService>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ChoreographyService service = (ChoreographyService)this.checkFuture((Future)entry.getValue());
                if (service == null) continue;
                services.add(service);
            }
            catch (Exception e) {
                this.logger.error((Object)("Could not get service from future: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return services;
    }

    private class NodeUpgrader
    implements Runnable {
        NodePoolManager npm = new NodesClient(Configuration.get(Configuration.Option.DEPLOYMENT_MANAGER_URI));
        String nodeId;

        public NodeUpgrader(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public void run() {
            try {
                this.npm.upgradeNode(this.nodeId);
            }
            catch (NodeNotUpgradedException e) {
                Deployer.this.logger.error((Object)("Bad response from /nodes/" + this.nodeId + "/upgrade; maybe some service is not deployed"));
            }
            catch (NodeNotFoundException e) {
                Deployer.this.logger.error((Object)("Bad response from /nodes/" + this.nodeId + "/upgrade; maybe some service is not deployed"));
            }
            catch (Fault e) {
                throw e;
            }
        }
    }

    private class ServiceUpdateInvoker
    implements Callable<ChoreographyService> {
        private ChoreographyService choreographyService;

        public ServiceUpdateInvoker(ChoreographyService choreographyService) {
            this.choreographyService = choreographyService;
        }

        @Override
        public ChoreographyService call() throws ServiceNotModifiedException, UnhandledModificationException {
            try {
                DeployableService a = Deployer.this.servicesManager.updateService((DeployableServiceSpec)this.choreographyService.getChoreographyServiceSpec().getServiceSpec());
                this.choreographyService.setService((Service)a);
            }
            catch (ServiceNotModifiedException e) {
                Deployer.this.logger.error((Object)e.getMessage());
                throw e;
            }
            catch (UnhandledModificationException e) {
                Deployer.this.logger.error((Object)e.getMessage());
                throw e;
            }
            return this.choreographyService;
        }
    }

    private class ServicesManagerInvoker
    implements Callable<ChoreographyService> {
        ChoreographyServiceSpec choreographyServiceSpec;

        public ServicesManagerInvoker(ChoreographyServiceSpec choreographyServiceSpec) {
            this.choreographyServiceSpec = choreographyServiceSpec;
        }

        @Override
        public ChoreographyService call() throws Exception {
            try {
                DeployableService deployed = Deployer.this.servicesManager.createService((DeployableServiceSpec)this.choreographyServiceSpec.getServiceSpec());
                return this.getChoreographyService(deployed);
            }
            catch (ServiceNotDeployedException e) {
                Deployer.this.logger.error((Object)"Probably DeploymentManager is off");
                throw e;
            }
        }

        private ChoreographyService getChoreographyService(DeployableService d) {
            ChoreographyService s = new ChoreographyService(this.choreographyServiceSpec);
            s.setService((Service)d);
            return s;
        }
    }
}

